using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Programmer.Classes;
using Zensys.Framework;

namespace Zensys.ZWave.Programmer.UI
{
    /// <summary>
    /// SettingsForm class. Represents the Settings View.
    /// </summary>
    public partial class SettingsForm : Form
    {
        private EventHandler mOnLoadInterfaces;
        /// <summary>
        /// Occurs when Load Interfaces called.
        /// </summary>
        public event EventHandler OnLoadInterfaces
        {
            add { mOnLoadInterfaces += value; }
            remove { mOnLoadInterfaces -= value; }
        }

        private Win32PnPEntityClass mSelectedPortInfo;

        /// <summary>
        /// Gets or sets the Selected Port Info.
        /// </summary>
        /// <value>The Selected Port Info.</value>
        public Win32PnPEntityClass SelectedPortInfo
        {
            get { return mSelectedPortInfo; }
            set { mSelectedPortInfo = value; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SettingsForm"/> class.
        /// </summary>
        public SettingsForm()
        {
            InitializeComponent();
        }

        private void SettingsForm_Load(object sender, EventArgs e)
        {
            if (mOnLoadInterfaces != null)
            {
                mOnLoadInterfaces(sender, e);
            }
        }

        #region View Members
        
        internal System.Windows.Forms.Button CmdCancel
        {
            get { return cmdCancel; }
        }

        internal System.Windows.Forms.Button CmdOK
        {
            get { return cmdOK; }
        }

        internal System.Windows.Forms.Button CmdApply
        {
            get { return cmdApply; }
        }

        internal System.Windows.Forms.Button CmdDefaults
        {
            get { return cmdDefaults; }
        }

        internal System.Windows.Forms.CheckedListBox InterfacesListBox
        {
            get { return interfacesListBox; }
        }

        internal System.Windows.Forms.PropertyGrid SettingsPropertyGrid
        {
            get { return settingsPropertyGrid; }
        }

        internal Label NoCommInterfacesLabel
        {
            get { return lblEmpty; }
        }

		internal System.Windows.Forms.TabControl MainTabControl
		{
			get { return mainTabControl; }
		}
        #endregion

        private void interfacesListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            for (int i = 0; i < interfacesListBox.Items.Count; i++)
            {
                interfacesListBox.SetItemChecked(i, false);
            }
            interfacesListBox.SetItemChecked(interfacesListBox.SelectedIndex, true);
            SelectedPortInfo = ((InterfaceWrapper)interfacesListBox.SelectedItem).PortInfo;
        }


        private void interfacesListBox_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            System.Diagnostics.Debug.WriteLine("NewValue " + e.NewValue.ToString());
            System.Diagnostics.Debug.WriteLine("CurrentValue " + e.CurrentValue.ToString());
            System.Diagnostics.Debug.WriteLine("");
            if (e.NewValue == CheckState.Unchecked)
            {
                SelectedPortInfo = null;
            }
            else
            {
                if (interfacesListBox.SelectedItem != null)
                {
                    SelectedPortInfo = ((InterfaceWrapper)interfacesListBox.SelectedItem).PortInfo;
                }
            }
        }
    }
}