using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Interfaces
{
    /// <summary>
    /// Defines methods for binding views (windows forms) and controller extentions <see cref="BaseAction"/>
    /// </summary>
    public interface IViewDispatcher
    {
        /// <summary>
        /// Binds the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        /// <param name="documentModel">The document model.</param>
        void Bind(IView view, ActionCollection actions, DocumentModel documentModel);
        /// <summary>
        /// Drops the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        /// <param name="documentModel">The document model.</param>
        void Drop(IView view, ActionCollection actions, DocumentModel documentModel);
    }
}
