using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Interfaces;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Dispatchers
{
    /// <summary>
    /// MainFormDispatcher class. Bind/Unbind functions to the Main Form controls.
    /// </summary>
    public class MainFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;

            //Form
            form.Load += new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);

            form.MainDockPanel.ActiveContentChanged += new EventHandler(actions.MainFormActions.OnActiveContentChanged);

            //View
            form.ZW010xToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnZW010xClick);
            form.ZW020xToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnZW020xClick);
            form.ZW030xToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnZW030xClick);
            form.ZW040xToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnZW040xClick);
            form.ConsoleToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnConsoleClick);
            form.LogToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnLogClick);
            form.SettingsToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnSettingsClick);
			form.DetectTargetToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnDetectTargetClick);
			form.UpgradeFirmwareToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnUpgradeFirmwareClick);
			form.UploadFirmwareToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnUploadFirmwareClick);
            form.CalibrateToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnCalibrateClick);


            form.ExitToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnExitClick);

            form.ResetZWaveModuleToolStripMenuItem.Click += new EventHandler(actions.MainFormActions.OnResetZWaveModuleClick);
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.MainFormActions.OnDocumentModelStateChanged);

            form.KeyDown += new System.Windows.Forms.KeyEventHandler(actions.MainFormActions.OnKeyDown);
        }


        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;

            //Form
            form.Load -= new EventHandler(actions.MainFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.MainFormActions.OnFormClosing);

            form.MainDockPanel.ActiveContentChanged -= new EventHandler(actions.MainFormActions.OnActiveContentChanged);

            //View
            form.ZW010xToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnZW010xClick);
            form.ZW020xToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnZW020xClick);
            form.ZW030xToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnZW030xClick);
            form.ZW040xToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnZW040xClick);
            form.ConsoleToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnConsoleClick);
            form.LogToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnLogClick);
            form.SettingsToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnSettingsClick);
			form.DetectTargetToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnDetectTargetClick);
			form.UpgradeFirmwareToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnUpgradeFirmwareClick);
			form.UploadFirmwareToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnUploadFirmwareClick);
            form.CalibrateToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnCalibrateClick);

            form.ExitToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnExitClick);
            form.ResetZWaveModuleToolStripMenuItem.Click -= new EventHandler(actions.MainFormActions.OnResetZWaveModuleClick);

            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.MainFormActions.OnDocumentModelStateChanged);
            form.KeyDown -= new System.Windows.Forms.KeyEventHandler(actions.MainFormActions.OnKeyDown);
        }

        #endregion
    }
}
