using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Controllers;
using Zensys.ZWave.Programmer.Actions;

namespace Zensys.ZWave.Programmer.Classes
{
    /// <summary>
    /// ActionCollection class. Contains references to the application Action classes.
    /// </summary>
    public class ActionCollection : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ActionCollection"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ActionCollection(ControllerManager controller)
            : base(controller)
        {
        }

        private MainFormActions mMainFormActions;
        /// <summary>
        /// Gets the Main Form actions.
        /// </summary>
        /// <value>The Main Form actions.</value>
        public MainFormActions MainFormActions
        {
            get
            {
                if (mMainFormActions == null) mMainFormActions = new MainFormActions(this.ControllerManager);
                return mMainFormActions;
            }
        }

        private ConsoleFormActions mConsoleFormActions;

        /// <summary>
        /// Gets the Console Form actions.
        /// </summary>
        /// <value>The Console Form actions.</value>
        public ConsoleFormActions ConsoleFormActions
        {
            get
            {
                if (mConsoleFormActions == null) mConsoleFormActions = new ConsoleFormActions(this.ControllerManager);
                return mConsoleFormActions;
            }
        }
        private LogFormActions mLogFormActions;

        /// <summary>
        /// Gets the Log Form actions.
        /// </summary>
        /// <value>The Log Form actions.</value>
        public LogFormActions LogFormActions
        {
            get
            {
                if (mLogFormActions == null) mLogFormActions = new LogFormActions(this.ControllerManager);
                return mLogFormActions;
            }
        }
        private ZW010xFormActions mZW010xFormActions;

        /// <summary>
        /// Gets the ZW010x Form actions.
        /// </summary>
        /// <value>The ZW010x Form actions.</value>
        public ZW010xFormActions ZW010xFormActions
        {
            get
            {
                if (mZW010xFormActions == null) mZW010xFormActions = new ZW010xFormActions(this.ControllerManager);
                return mZW010xFormActions;
            }

        }
        private ZW020xFormActions mZW020xFormActions;

        /// <summary>
        /// Gets the ZW020x Form actions.
        /// </summary>
        /// <value>The ZW020x Form actions.</value>
        public ZW020xFormActions ZW020xFormActions
        {
            get
            {
                if (mZW020xFormActions == null) mZW020xFormActions = new ZW020xFormActions(this.ControllerManager);
                return mZW020xFormActions;
            }

        }
        private ZW030xFormActions mZW030xFormActions;

        /// <summary>
        /// Gets the ZW030x Form actions.
        /// </summary>
        /// <value>The ZW030x Form actions.</value>
        public ZW030xFormActions ZW030xFormActions
        {
            get
            {
                if (mZW030xFormActions == null) mZW030xFormActions = new ZW030xFormActions(this.ControllerManager);
                return mZW030xFormActions;
            }
        }
        private ZW040xFormActions mZW040xFormActions;

        /// <summary>
        /// Gets the ZW040x Form actions.
        /// </summary>
        /// <value>The ZW040x Form actions.</value>
        public ZW040xFormActions ZW040xFormActions
        {
            get
            {
                if (mZW040xFormActions == null) mZW040xFormActions = new ZW040xFormActions(this.ControllerManager);
                return mZW040xFormActions;
            }
        }

        private ProgrammerActions mProgrammerActions;

        /// <summary>
        /// Gets the Programmer actions (Common functions that used to programm the chip).
        /// </summary>
        /// <value>The Programmer actions.</value>
        public ProgrammerActions ProgrammerActions
        {
            get
            {
                if (mProgrammerActions == null) mProgrammerActions = new ProgrammerActions(this.ControllerManager);
                return mProgrammerActions;
            }

        }
        private CommonActions mCommonActions;

        /// <summary>
        /// Gets the Common actions.
        /// </summary>
        /// <value>The common actions.</value>
        public CommonActions CommonActions
        {
            get
            {
                if (mCommonActions == null) mCommonActions = new CommonActions(this.ControllerManager);
                return mCommonActions;
            }
        }
    }
}
