using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Controllers;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Programmer.Properties;
using System.Windows.Forms;

namespace Zensys.ZWave.Programmer.Actions
{
    /// <summary>
    /// ZW020xFormActions class. Contains ZW020x Form functions.
    /// </summary>
    public class ZW020xFormActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ZW020xFormActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ZW020xFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        #region Form
        /// <summary>
        /// Called when Form load.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.MainForm.ZW020xToolStripMenuItem.Checked = true;
        }

        /// <summary>
        /// Called when form shown.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnShown(object sender, EventArgs e)
        {
            ControllerManager.UpdateFrequencies();
        }
        /// <summary>
        /// Called when Form closing.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormClosing(object sender, EventArgs e)
        {
            ControllerManager.Actions.MainFormActions.SaveSettings();
            ControllerManager.MainForm.ZW020xToolStripMenuItem.Checked = false;
        }
        #endregion

        /// <summary>
        /// Called when Flash browse HEX file click.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFlashBrowseHexFileClick(object sender, EventArgs e)
        {
            if (ControllerManager.ZW020xForm != null && !ControllerManager.ZW020xForm.IsDisposed)
            {
                ControllerManager.DocumentModel.SetFlashHexFileName(ChipTypes.ZW020x, ControllerManager.Actions.CommonActions.BrowseFile());
                ControllerManager.ZW020xForm.FlashHexFileNameTextBox.Text = ControllerManager.DocumentModel.GetFlashHexFileName(ChipTypes.ZW020x);
                ControllerManager.Actions.ProgrammerActions.UpdateUserFlashSettingsToDefault(ChipTypes.ZW020x);
            }
        }
        /// <summary>
        /// Called when EEPROM browse HEX file click.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnEEPROMBrowseHexFileClick(object sender, EventArgs e)
        {
            if (ControllerManager.ZW020xForm != null && !ControllerManager.ZW020xForm.IsDisposed)
            {
                ControllerManager.DocumentModel.SetEepromHexFileName(ChipTypes.ZW020x, ControllerManager.Actions.CommonActions.BrowseFile());
                ControllerManager.ZW020xForm.EepromHexFileNameTextBox.Text = ControllerManager.DocumentModel.GetEepromHexFileName(ChipTypes.ZW020x);
            }
        }
        /// <summary>
        /// Called when Flash HEX file name changed.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFlashHexFileNameChanged(object sender, EventArgs e)
        {
            if (ControllerManager.ZW020xForm != null && !ControllerManager.ZW020xForm.IsDisposed)
            {
                //ControllerManager.DocumentModel.SetFlashHexFileName(ChipTypes.ZW020x, ControllerManager.ZW020xForm.FlashHexFileNameTextBox.Text);
            }
        }

        /// <summary>
        /// Called when EEPROM HEX file name changed.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnEepromHexFileNameChanged(object sender, EventArgs e)
        {
            if (ControllerManager.ZW020xForm != null && !ControllerManager.ZW020xForm.IsDisposed)
            {
                //ControllerManager.DocumentModel.SetEepromHexFileName(ChipTypes.ZW020x, ControllerManager.ZW020xForm.EepromHexFileNameTextBox.Text);
            }
        }
        /// <summary>
        /// Called when DocumentModel state changed.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.ZW020xForm != null && !ControllerManager.ZW020xForm.IsDisposed)
            {

                if (ControllerManager.ZW020xForm.InvokeRequired)
                {
                    ControllerManager.ZW020xForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.ZW020xForm.FlashProgramButton.Enabled =
                    ControllerManager.ZW020xForm.FlashWriteButton.Enabled =
                    ControllerManager.ZW020xForm.FlashCompareButton.Enabled =
                        ControllerManager.DocumentModel.FlashHexFileSelected(ChipTypes.ZW020x);

                    ControllerManager.ZW020xForm.EepromProgramButton.Enabled =
                    ControllerManager.ZW020xForm.EepromCompareButton.Enabled =
                        ControllerManager.DocumentModel.EepromHexFileSelected(ChipTypes.ZW020x);

                }
            }
        }

		/// <summary>
		/// Called when Set Lock Bits click.
		/// </summary>
		/// <param name="sender">The sender.</param>
		/// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
		public void OnLockBitsSetClick(object sender, EventArgs e)
		{
			ControllerManager.Actions.ProgrammerActions.OnLockBitsSet(
				ControllerManager.ZW020xForm.LockBitsDisableFlashReadCheckBox.Checked,
				ControllerManager.ZW020xForm.LockBitsBootBlockLockCheckBox.Checked,
				ControllerManager.ZW020xForm.LockBitsBootSectorSizeComboBox.SelectedIndex);
		}

		/// <summary>
		/// Called when Read Lock Bits click.
		/// </summary>
		/// <param name="sender">The sender.</param>
		/// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
		public void OnLockBitsReadClick(object sender, EventArgs e)
		{
			bool disableFlashRead, lockBootBlock;
			int bootSectorSize;

			ControllerManager.Actions.ProgrammerActions.OnLockBitsRead(
				out disableFlashRead, out lockBootBlock, out bootSectorSize);

			ControllerManager.ZW020xForm.LockBitsDisableFlashReadCheckBox.Checked = disableFlashRead;
			ControllerManager.ZW020xForm.LockBitsBootBlockLockCheckBox.Checked = lockBootBlock;
			ControllerManager.ZW020xForm.LockBitsBootSectorSizeComboBox.SelectedIndex = bootSectorSize;
		}

        public void OnKeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.O)
            {
                OnFlashBrowseHexFileClick(null, null);
            }
            if (e.Control && e.KeyCode == Keys.P)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashProgramClick(null, null);
            }
            if (e.Control && e.KeyCode == Keys.W)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashWriteClick(null, null);
            }
            if (e.Control && e.KeyCode == Keys.E)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashEraseClick(null, null);
            }
            if (e.Control && e.KeyCode == Keys.R)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashReadClick(null, null);
            }
            if (e.Control && e.KeyCode == Keys.M)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashCompareClick(null, null);
            }
            if (e.Shift && e.KeyCode == Keys.W)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashWriteOptionsClick(null, null);
            }
            if (e.Shift && e.KeyCode == Keys.R)
            {
                ControllerManager.Actions.ProgrammerActions.OnFlashReadOptionsClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.O)
            {
                OnEEPROMBrowseHexFileClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.P)
            {
                ControllerManager.Actions.ProgrammerActions.OnEEPROMWriteClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.E)
            {
                ControllerManager.Actions.ProgrammerActions.OnEEPROMEraseClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.R)
            {
                ControllerManager.Actions.ProgrammerActions.OnEEPROMReadClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.M)
            {
                ControllerManager.Actions.ProgrammerActions.OnEEPROMCompareClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.F1)
            {
                ControllerManager.Actions.ProgrammerActions.OnWriteHomeIdClick(null, null);
            }
            if (e.Alt && e.KeyCode == Keys.F2)
            {
                ControllerManager.Actions.ProgrammerActions.OnReadHomeIdClick(null, null);
            }
        }

    }
}
