using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Controllers;
using Zensys.ZWave.Logging;
using Zensys.Framework;
using System.Windows.Forms;
using System.Threading;
using Zensys.ZWave.Programmer.UI;
using Zensys.Framework.UI.Controls;
using System.Data;

namespace Zensys.ZWave.Programmer.Actions
{
    /// <summary>
    /// LogFormActions class. Contains Log Form functions.
    /// </summary>
    public class LogFormActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LogFormActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public LogFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        #region Form
        /// <summary>
        /// Called when Form load.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormLoad(object sender, EventArgs e)
        {
            BindData();
            ControllerManager.MainForm.LogToolStripMenuItem.Checked = true;
        }

        private void BindData()
        {
            ControllerManager.LogForm.logGridViewControl.LogGridView.Columns[4].Visible = false;
            ControllerManager.ZWaveManager.LogDataSource.Ctx = SynchronizationContext.Current;
            DataColumn dcIsPut = new DataColumn("IsPut", typeof(bool));
            DataColumn dcIsRequest = new DataColumn("IsRequest", typeof(bool));
            DataColumn dcTime = new DataColumn("Time", typeof(DateTime));
            DataColumn dcApplicationString = new DataColumn("ApplicationString", typeof(string));
            DataColumn dcPayload = new DataColumn("Payload", typeof(byte[]));

            ControllerManager.LogForm.logGridViewControl.DataTable.Columns.Add(dcIsPut);
            ControllerManager.LogForm.logGridViewControl.DataTable.Columns.Add(dcIsRequest);
            ControllerManager.LogForm.logGridViewControl.DataTable.Columns.Add(dcTime);
            ControllerManager.LogForm.logGridViewControl.DataTable.Columns.Add(dcApplicationString);
            ControllerManager.LogForm.logGridViewControl.DataTable.Columns.Add(dcPayload);
            ControllerManager.ZWaveManager.LogDataSource.ListChanged += new System.ComponentModel.ListChangedEventHandler(LogDataSource_ListChanged);
        }

        void LogDataSource_ListChanged(object sender, System.ComponentModel.ListChangedEventArgs e)
        {
            switch (e.ListChangedType)
            {
                case System.ComponentModel.ListChangedType.ItemAdded:
                    ControllerManager.LogForm.logGridViewControl.DataTable.Rows.Add(new object[] 
                    { 
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].IsPut,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].IsRequest,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].Time,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].ApplicationString,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].Payload
                    });

                    break;
                case System.ComponentModel.ListChangedType.ItemChanged:
                    break;
                case System.ComponentModel.ListChangedType.ItemDeleted:
                    break;
                case System.ComponentModel.ListChangedType.ItemMoved:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorAdded:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorChanged:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorDeleted:
                    break;
                case System.ComponentModel.ListChangedType.Reset:
                    ControllerManager.LogForm.logGridViewControl.DataTable.Rows.Clear();
                    foreach (LogPacket lp in ControllerManager.ZWaveManager.LogDataSource)
                    {
                        ControllerManager.LogForm.logGridViewControl.DataTable.Rows.Add(new object[] 
                        { 
                            lp.IsPut,
                            lp.IsRequest,
                            lp.Time,
                            lp.ApplicationString,
                            lp.Payload
                        });
                    }

                    break;
                default:
                    break;
            }
        }
        /// <summary>
        /// Called when Form closing.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormClosing(object sender, EventArgs e)
        {
            ControllerManager.MainForm.LogToolStripMenuItem.Checked = false;
        }
        #endregion
    }
}
