using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Controllers;
using System.Windows.Forms;
using System.IO;

namespace Zensys.ZWave.Programmer.Actions
{
    /// <summary>
    /// ConsoleFormActions class. Contains Console Form functions.
    /// </summary>
    public class ConsoleFormActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ConsoleFormActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ConsoleFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        #region Form
        /// <summary>
        /// Called when form load.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.MainForm.ConsoleToolStripMenuItem.Checked = true;
        }
        /// <summary>
        /// Called when form closing.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnFormClosing(object sender, EventArgs e)
        {
            ControllerManager.MainForm.ConsoleToolStripMenuItem.Checked = false;
        }
        #endregion

        /// <summary>
        /// Called when Clear click.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnClearClick(object sender, EventArgs e)
        {
            if (ControllerManager.ConsoleForm != null && !ControllerManager.ConsoleForm.IsDisposed)
            {
                ControllerManager.ConsoleForm.ContentTextBox.Text = "";
            }
        }
        /// <summary>
        /// Called when Save click.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnSaveClick(object sender, EventArgs e)
        {
            if (ControllerManager.ConsoleForm != null && !ControllerManager.ConsoleForm.IsDisposed)
            {
                if (!String.IsNullOrEmpty(ControllerManager.ConsoleForm.ContentTextBox.Text))
                {
                    SaveFileDialog saveFileDialog = new SaveFileDialog();
                    saveFileDialog.Filter = "Intel hex files (*.hex)|*.hex|All files (*.*)|*.*";
                    saveFileDialog.FilterIndex = 1;
                    if (saveFileDialog.ShowDialog() == DialogResult.OK)
                    {
                        TextWriter writer = new StreamWriter(saveFileDialog.FileName);
                        writer.Write(ControllerManager.ConsoleForm.ContentTextBox.Text);
                        writer.Close();
                    }
                }
            }
        }
        /// <summary>
        /// Called when Copy click.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        public void OnCopyClick(object sender, EventArgs e)
        {
            if (ControllerManager.ConsoleForm != null && !ControllerManager.ConsoleForm.IsDisposed)
            {
                if (!String.IsNullOrEmpty(ControllerManager.ConsoleForm.ContentTextBox.Text))
                {
                    Clipboard.Clear();
                    if (!String.IsNullOrEmpty(ControllerManager.ConsoleForm.ContentTextBox.SelectedText))
                    {
                        Clipboard.SetText(ControllerManager.ConsoleForm.ContentTextBox.SelectedText);
                    }
                    else
                    {
                        Clipboard.SetText(ControllerManager.ConsoleForm.ContentTextBox.Text);
                    }
                }
            }
        }




    }
}
