using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.Programmer.Actions
{
    /// <summary>
    /// CommonActions class. Contains common functions.
    /// </summary>
    public class CommonActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CommonActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public CommonActions(ControllerManager controller)
            : base(controller)
        {

        }
       
        /// <summary>
        /// Browse the HEX file (Flash, EEPROM, SRAM etc.).
        /// </summary>
        /// <returns></returns>
        public string BrowseFile()
        {
            string fileName = "";
            using (OpenFileDialog dlgOpenFile = new OpenFileDialog())
            {
                dlgOpenFile.Filter = "Intel hex files (*.hex)|*.hex|All files (*.*)|*.*";
                dlgOpenFile.FilterIndex = 1;
                if (dlgOpenFile.ShowDialog() == DialogResult.OK)
                {
                    fileName = dlgOpenFile.FileName;
                }
            }
            return fileName;
        }
        internal void OnAutoIncrementHomeIdCheckedChanged(object sender, EventArgs e)
        {
            if (sender is CheckBox)
            {
                Form form = ((CheckBox)sender).FindForm();
                if (form != null)
                {
                    if (form is ZW010xForm)
                    {
                        ControllerManager.ZW010xForm.StartHomeIdTextBox.Enabled = ControllerManager.ZW010xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW010xForm.EndHomeIdTextBox.Enabled = ControllerManager.ZW010xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW010xForm.CurrentHomeIdTextBox.Enabled = !ControllerManager.ZW010xForm.AutoIncrementHomeIdCheckBox.Checked;
                    }
                    else if (form is ZW020xForm)
                    {
                        ControllerManager.ZW020xForm.StartHomeIdTextBox.Enabled = ControllerManager.ZW020xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW020xForm.EndHomeIdTextBox.Enabled = ControllerManager.ZW020xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW020xForm.CurrentHomeIdTextBox.Enabled = !ControllerManager.ZW020xForm.AutoIncrementHomeIdCheckBox.Checked;
                    }
                    else if (form is ZW030xForm)
                    {
                        ControllerManager.ZW030xForm.StartHomeIdTextBox.Enabled = ControllerManager.ZW030xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW030xForm.EndHomeIdTextBox.Enabled = ControllerManager.ZW030xForm.AutoIncrementHomeIdCheckBox.Checked;
                        ControllerManager.ZW030xForm.CurrentHomeIdTextBox.Enabled = !ControllerManager.ZW030xForm.AutoIncrementHomeIdCheckBox.Checked;
                    }
					else if (form is ZW040xForm)
					{
						ControllerManager.ZW040xForm.StartHomeIdTextBox.Enabled = ControllerManager.ZW040xForm.AutoIncrementHomeIdCheckBox.Checked;
						ControllerManager.ZW040xForm.EndHomeIdTextBox.Enabled = ControllerManager.ZW040xForm.AutoIncrementHomeIdCheckBox.Checked;
						ControllerManager.ZW040xForm.CurrentHomeIdTextBox.Enabled = !ControllerManager.ZW040xForm.AutoIncrementHomeIdCheckBox.Checked;
					}
				}
            }
        }
        /// <summary>
        /// Checks the device chip type compatibility.
        /// </summary>
        /// <param name="device">The device.</param>
        /// <returns></returns>
        public bool CheckDeviceChipTypeCompatibility(IDevice device)
        {
            return ControllerManager.DocumentModel.SelectedChipType == device.ChipType;
        }

    }
}
