/******************************* ZW_FLiRS.c *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Implements functions that make is easier to support
 *              Battery Operated Nodes in FLiRS mode.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.00 $
 * Last Changed:     $Date: 2009-03-24 15:27:36 +0200 (Ср, 25 Лют 2009) $
 *
 ****************************************************************************/


#define ZW_BEAM_RX_WAKEUP

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <ZW_slave_api.h>
#include <ZW_debug_api.h>
#include <ZW_power_api.h>
#include <ZW_uart_api.h>
#include <ZW_FLiRS.h>
#include <ZW_pindefs.h>
#include <slave_learn.h>

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
#define LONG_SLEEP_TIMEOUT    200
#define ALARM_TIMEOUT_COUNT   3   /* Timeout on an alarm is ALARM_TIMEOUT_COUNT*LONG_SLEEP_TIMEOUT */

BYTE bSleepTimeout; /* Timer handler for sleep timer */
BYTE bSleepTimerCount;

/*================================   GotoSleep   ============================
**    Power down the ZW0201 chip
**
**
**
**--------------------------------------------------------------------------*/
void GotoSleep()
{
  ZW_DEBUG_SEND_BYTE('G');

///  PIN_IN(Button, 1);

//  EX1 = 1;  /* enable int1 (button) before power down */
  /* Goto sleep */

  if(!learnState)
  {
  	ZW_SetSleepMode(ZW_FREQUENTLY_LISTENING_MODE, ZW_INT_MASK_EXT1, 0);
  }


}

/*=============================  SleepTimeout   =========================
**    Timeout function for going back to sleep
**
**    Side effects:
**
**--------------------------------------------------------------------------*/

void SleepTimeout()
{
  ZW_DEBUG_SEND_BYTE('t');
  bSleepTimerCount--;
  if (bSleepTimerCount == 0)
  {
    ZW_DEBUG_SEND_BYTE('T');
    bSleepTimeout = 0;
    GotoSleep();
  }
}

/*========================  FLiRS_SleepTimeoutStop   =========================
**    Stop the timeout timer for going back to sleep
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void FLiRS_SleepTimeoutStop()
{
  ZW_DEBUG_SEND_BYTE('s');
  ZW_DEBUG_SEND_BYTE('t');

  if (bSleepTimeout)
    if(TimerCancel(bSleepTimeout))
	{
  		ZW_DEBUG_SEND_BYTE('1');
  		ZW_DEBUG_SEND_BYTE(' ');
	
	}
	else
	{
  		ZW_DEBUG_SEND_BYTE('0');
  		ZW_DEBUG_SEND_BYTE(' ');
	}
  ZW_DEBUG_SEND_NUM(bSleepTimeout);
  ZW_DEBUG_SEND_BYTE(' ');

  bSleepTimeout = 0;
}

/*=============================  FLiRS_SleepTimeoutStart   ===================
**    Start the timeout timer for going back to sleep
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void FLiRS_SleepTimeoutStart(BOOL bLong)
{
  ZW_DEBUG_SEND_BYTE('S');
  ZW_DEBUG_SEND_NUM(bLong);
  if (bLong)
    bSleepTimerCount = ALARM_TIMEOUT_COUNT;
  else
    bSleepTimerCount = 2;

  if (!bSleepTimeout)
    bSleepTimeout = TimerStart(SleepTimeout, LONG_SLEEP_TIMEOUT, bSleepTimerCount);
  else
  {
    TimerCancel(bSleepTimeout);
    bSleepTimeout = TimerStart(SleepTimeout, LONG_SLEEP_TIMEOUT, bSleepTimerCount);
  }
  ZW_DEBUG_SEND_NUM(bSleepTimeout);
  ZW_DEBUG_SEND_BYTE(' ');

  if(bSleepTimeout == 0xff)
  {
    bSleepTimeout = 0;
  }
}


