/*******************************  EEPROM.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Header file for EEPROM access routines
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 9312 $
 * Last Changed:     $Date: 2007-09-17 15:21:42 +0200 (ma, 17 sep 2007) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#define EEPROM_START                0x00

#define MAX_NODES 232
#define DEFAULT_SUC_NODE_ID  0x00

extern BYTE groupMask[MAX_NODES/8];

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
/*============================   StoreGroupLevel   ======================
**    Function description
**      Stores the current dim level in External EEPROM
**    Side effects:
**
**--------------------------------------------------------------------------*/
void StoreGroupLevel(
BYTE level);           /*IN Current group dim level*/

/*============================   GetGroupLevel   ======================
**    Function description
**      Gets the current dim level in External EEPROM
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE GetGroupLevel(void);           /*RET Current group dim level*/

/*============================   ClearGroupTable   ======================
**    Function description
**      Clears the group table and calls call back when done.
**      Remember to update ram table when done.
**    Side effects:
**
**--------------------------------------------------------------------------*/
void ClearGroupTable(void (*func)(void));

/*============================   RemoveNodeFromGroup   ======================
**    Function description
**      Removes a node from a group.
**    Side effects:
**      updates the groupArray
**--------------------------------------------------------------------------*/
void RemoveNodeFromGroup(
BYTE bNodeID);             /*IN NodeID to remove*/

/*============================   AddNodeToGroup   ======================
**    Function description
**      Adds a node to a group.
**    Side effects:
**      updates the groupArray
**--------------------------------------------------------------------------*/
void AddNodeToGroup(BYTE bNodeID);

/*============================   UpdateRAMGroupList   ======================
**    Function description
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE                      /*RETURN number of nodes in the list*/
UpdateRAMGroupList(void);

/*============================   IsNodeInGroup   ======================
**    Function description
**      Check if a node is in the group
**    Side effects:
**
**--------------------------------------------------------------------------*/
BOOL IsNodeInGroup(BYTE bNodeID);

/*============================   GetGroupListDimmers   ======================
**    Build a nodemask of nodes that has their generic type set to SWITCH_MULTILEVEL
**
**    Returns: Number of multilevel nodes found
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE                      /*RETURN number of nodes in the list*/
GetGroupListDimmers(BYTE *pbList);

#endif /* __H_ */
