/********************************  EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Valeriy Vyshnyak
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 2256 $
 * Last Changed:     $Date: 2002-05-07 12:00:47 +0300 (Вв, 07 Тра 2002) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */

/* EEPROM Door Lock node layout */
#define EEOFFSET_LOCK_STATUS        0x00
#define EEOFFSET_LOCK_STATUS_SIZE   1


#define EEOFFSET_POWER_LEVEL		EEOFFSET_LOCK_STATUS + EEOFFSET_LOCK_STATUS_SIZE  /* MAGIC */
#define EEOFFSET_POWER_LEVEL_SIZE	1

#define EEOFFSET_TIMER_POWER_LEVEL	EEOFFSET_POWER_LEVEL + EEOFFSET_POWER_LEVEL_SIZE
#define EEOFFSET_TIMER_POWER_LEVEL_SIZE	1

#define EEOFFSET_TEST_NODE_ID		EEOFFSET_TIMER_POWER_LEVEL + EEOFFSET_TIMER_POWER_LEVEL_SIZE
#define EEOFFSET_TEST_NODE_ID_SIZE	1

#define EEOFFSET_TEST_POWER_LEVEL	EEOFFSET_TEST_NODE_ID + EEOFFSET_TEST_NODE_ID_SIZE
#define EEOFFSET_TEST_POWER_LEVEL_SIZE  1

#define EEOFFSET_TEST_FRAME_COUNT	EEOFFSET_TEST_POWER_LEVEL + EEOFFSET_TEST_POWER_LEVEL_SIZE
#define EEOFFSET_TEST_FRAME_COUNT_SIZE	1

#define EEOFFSET_TEST_SOURCE_NODE_ID EEOFFSET_TEST_FRAME_COUNT + EEOFFSET_TEST_FRAME_COUNT_SIZE
#define EEOFFSET_TEST_SOURCE_NODE_ID_SIZE	1




#define EEOFFSET_OPERATION_TYPE              EEOFFSET_TEST_SOURCE_NODE_ID + EEOFFSET_TEST_SOURCE_NODE_ID_SIZE
#define EEOFFSET_OPERATION_TYPE_SIZE	1

#define EEOFFSET_HANDLES_STATE              EEOFFSET_OPERATION_TYPE + EEOFFSET_OPERATION_TYPE_SIZE
#define EEOFFSET_HANDLES_STATE_SIZE	1

#define EEOFFSET_LOCK_MINUTES              EEOFFSET_HANDLES_STATE + EEOFFSET_HANDLES_STATE_SIZE
#define EEOFFSET_LOCK_MINUTES_SIZE	1

#define EEOFFSET_LOCK_SECONDS              EEOFFSET_LOCK_MINUTES + EEOFFSET_LOCK_MINUTES_SIZE
#define EEOFFSET_LOCK_SECONDS_SIZE	1




#define EEOFFSET_MAGIC              EEOFFSET_LOCK_SECONDS + EEOFFSET_LOCK_SECONDS_SIZE  /* MAGIC */
#define EEOFFSET_MAGIC_SIZE         1

#define EEOFFSET_TRANSPORT_SETTINGS_START EEOFFSET_MAGIC + EEOFFSET_MAGIC_SIZE
#define EEOFFSET_TRANSPORT_SETTINGS_SIZE  TRANSPORT_EEPROM_SETTINGS_SIZE


#define EEOFFSET_LERN_MODE              EEOFFSET_TRANSPORT_SETTINGS_START + EEOFFSET_TRANSPORT_SETTINGS_SIZE  /* LERN_MODE */
#define EEOFFSET_LERN_MODE_SIZE         1


/* Default values */
#define DEFAULT_LOCK_STATUS         DOOR_LOCK_OPERATION_REPORT_DOOR_UNSECURED
#define MAGIC_VALUE                 0x56


#endif /* _EEPROM_H_ */
