/******************************* filename *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description:
 *
 * Author:   Thomas Kristensen
 *
 * Last Changed By:  $Author: iza $
 * Revision:         $Revision: 21352 $
 * Last Changed:     $Date: 2011-09-23 10:59:46 +0200 (fr, 23 sep 2011) $
 *
 ****************************************************************************/
#ifndef _BIN_SENSOR_H_
#define _BIN_SENSOR_H_
/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#if defined(__ICCAVR__) || defined(__C51__)

/* Offsets into frame received */
#define OFFSET_CLASSCMD                       0x00
#define OFFSET_CMD                            0x01
#define OFFSET_PARAM_1                        0x02
#define OFFSET_PARAM_2                        0x03
#define OFFSET_PARAM_3                        0x04
#define OFFSET_PARAM_4                        0x05
#define OFFSET_PARAM_5                        0x06
#define OFFSET_PARAM_6                        0x07

/* How many classes do we belong to */
#ifdef BATTERY
#ifdef ZW_SELF_HEAL
#define CLASS_MEMBERSHIP_COUNT  6
#endif
#else
#define CLASS_MEMBERSHIP_COUNT  5
#endif


typedef struct s_nodeInfo_
{
   BYTE memberClass[CLASS_MEMBERSHIP_COUNT];  /* Command class membership */
} t_nodeInfo;

typedef struct s_nodeStatus_ {
  BYTE status;    /* Sensor report status    */
  BYTE level;     /* Reported sensor level   */
  BYTE onValue;   /* Destination node BASIC_SET on level */
  BYTE onTime;    /* Destination node on time (after sensor go off) */
} t_nodeStatus;

#if defined(ZW020x) || defined(ZW030x)
#define SENSOR_ACTIVATED() (PIN_GET(INT1pin)? FALSE : TRUE)
#endif /* ZW020x */

/* Default values */

#define MAGIC_VALUE                 0x42

/* Application states */
/* IDLE AND EXECUTE states are required by the battery libraray */
#define STATE_APPL_IDLE             0x00  /* Application is idle = doing nothing - allow powerdown */
#define STATE_HEAL_LOST             0x01  /* HEAL: Device is Lost, unable to contact SUC */
#define STATE_HEAL_ASSOCIATED_FAIL  0x02  /* HEAL: Unable to contact an associated Node, contact SUC */
#define STATE_BASIC_CMD             0x03  /* Button was pressed, node is sending a Basic Set to
                                             associated nodes (if they exist) or a Basic Report broadcast */
#define STATE_BASIC_CMD_START       0x04  /* Button was pressed, start sending a Basic Set to
                                             associated nodes or broadcast Basic Report */

#define STATE_KEEP_ALIVE            0x05  /* Button was held down, keep node alive for an extended
                                             period to accept messages */
#define STATE_LEARN_MODE            0x06  /* Button was pressed, device is in learn mode */
#define STATE_LEARN_MODE_START      0x07  /* Button was pressed, put device in learn mode */
#define STATE_CHECK_INPUT           0x08  /* Polling the button and the sensor */
#define STATE_EXECUTE               0x09  /* Waiting for a callback or other operation to finish, power down is prohibited */
#define STATE_WAKEUP_NOTIFICATION_START   0x10
#define STATE_WAKEUP_NOTIFICATION         0x11
#define STATE_COMMAND_HANDLER       0x12
#define STATE_WAIT_FOR_BUTTON_RELEASE     0x13 /*Stay here until button is released*/
#define STATE_BASIC_CMD_WAIT        0x14  /* Delay basic set to see if a triple press is performed */

/* TO#2024 fix, changed timeout from 5 to 8 seconds */
#define WATCHDOG_TIMEOUT              8 /* If state lasts longer it should restart timer at safe location */

/* Sensor bounce count determines how many consecutive */
/* "Sensor activated" or "Sensor deactivated" messages must */
/* be received before a change is triggered by sending off */
/* a binary sensor report. */
#define DEFAULT_SENSORBOUNCECOUNT 5

/* PowerDownTimeout determines the number of seconds */
/* the sensor is kept alive between powerdowns.      */
/* The default is one second, which is probably      */
/* too little if you are routing in your network.    */
#define BIN_POWERDOWNTIMEOUT    (DEFAULT_POWERDOWNTIMEOUT + 30)

/* KeepAliveTimeout determines the number of seconds */
/* the sensor is kept alive when the button is       */
/* activated for more than KEEPALIVEACTIVATEPERIOD   */
/* seconds. This can be used when installing the     */
/* sensor in a network.                              */
/* Default keepalive is 30 seconds. */
#define BIN_KEEPALIVETIMEOUT    (DEFAULT_KEEPALIVETIMEOUT + 5)

#define TIME_DELAY_BASIC_SET      100

#endif /* defined(__ICCAVR__) || defined(__C51__) */

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
extern ZW_APPLICATION_TX_BUFFER txBuf;
extern BYTE myNodeID;
extern BYTE myHomeID[4];
extern BYTE currentState;
extern BYTE nextState;
extern BOOL keepAliveActive;
extern BYTE masterNodeID;

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

void StartWatchdog( void );
void StopWatchdog( void );

#endif /*_BATTERY_SENSOR_H_*/
