using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.UI;
using WeifenLuo.WinFormsUI.Docking;
using Zensys.ZWave.UPnPBridge.Interfaces;

namespace Zensys.ZWave.UPnPBridge.UI
{
    public partial class MainForm : Form, IView
    {
        public MainForm()
        {
            DoubleBuffered = true;
            InitializeComponent();
        }

        #region IView Members

        public Form ViewContainer
        {
            get { throw new Exception("The method or operation is not implemented."); }
        }

        public System.Windows.Forms.MenuStrip MenuMain
        {
            get { return menuMain; }
        }
        public WeifenLuo.WinFormsUI.Docking.DockPanel DockPanelMain
        {
            get { return dockPanelMain; }
        }
        public System.Windows.Forms.StatusStrip StatusStripMain
        {
            get { return statusStripMain; }
        }
        public System.Windows.Forms.ToolStripMenuItem NodeToolStripMenuItem
        {
            get { return nodeToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem CmdClassToolStripMenuItem
        {
            get { return cmdClassToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem ControllerToolStripMenuItem
        {
            get { return controllerToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem SettingsToolStripMenuItem
        {
            get { return settingsToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem ExitToolStripMenuItem
        {
            get { return exitToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem HelpToolStripMenuItem
        {
            get { return helpToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem IndexToolStripMenuItem
        {
            get { return indexToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem ContentsToolStripMenuItem
        {
            get { return contentsToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem SearchToolStripMenuItem
        {
            get { return searchToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem AboutToolStripMenuItem
        {
            get { return aboutToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem LogToolStripMenuItem
        {
            get { return logToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem UPnPBinaryLightCPToolStripMenuItem
        {
            get { return uPnPBinaryLightCPToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem UPnPBridgedDevicesToolStripMenuItem
        {
            get { return uPnPBridgedDevicesToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem UPnPDeviceScannerToolStripMenuItem
        {
            get { return uPnPDeviceScannerToolStripMenuItem; }
        }
        public System.Windows.Forms.ToolStripMenuItem AssociationsToolStripMenuItem
        {
            get { return associationsToolStripMenuItem; }
        }
        
        public System.Windows.Forms.ToolStripMenuItem UPnPRendererCPToolStripMenuItem
        {
            get { return uPnPRendererCPToolStripMenuItem; }
        }

        public DockStyle mDockStyle = DockStyle.None;
        public DockStyle DockStyle
        {
            get
            {
                return mDockStyle;
            }
            set
            {
                mDockStyle = value;
            }
        }

        public string LabelHomeIdText
        {
            set
            {
                UpdateLabelText(tsslHome, "Home Id: " + value);
            }
        }

        public string LabelNodeIdText
        {
            set
            {
                UpdateLabelText(tsslNode, "Controller Node Id: " + value);
            }
        }

        public string LabelStatusText
        {
            set
            {
                UpdateLabelText(tsslStatus, "Status: " + value);
            }
        }
        public string LabelCommandQueue
        {
            set
            {
                UpdateLabelText(tssCommandQueue, String.Format("CommandQueue: {0} actions queued.", value));
            }
        }


        private delegate void ToolStripItemDelegate(ToolStripItem label, string text);
        private void UpdateLabelText(ToolStripItem label, string text)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new ToolStripItemDelegate(UpdateLabelText), new object[] { label, text });
            }
            else
            {
                label.Text = text;
            }
        }
        private delegate void LabelDelegate(Label label, string text);
        private void UpdateLabelText(Label label, string text)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new LabelDelegate(UpdateLabelText), new object[] { label, text });
            }
            else
            {
                label.Text = text;
            }
        }
        #endregion

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}