using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using OpenSource.UPnP;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.Logging;
using System.ComponentModel;
using System.Timers;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.Events;

namespace Zensys.ZWave.UPnPBridge.Models
{
    public class DocumentModel
    {
        public event EventHandler<EventArgs> DocumentModelStateChanged;
        public event EventHandler<EventArgs> ControllerChanging;
        private BindingContext mContext;
        public DocumentModel(BindingContext context)
        {
            mDevices = new ThreadedBindingList<IDeviceInfo>();
            mAssociativeDevices = new ThreadedBindingList<IDeviceInfo>();
            mAssociativeGroups = new ThreadedBindingList<AssociativeGroup>(); 
            mBridgedDevices = new BindingList<BridgedDevice>();
            mControllers = new BindingList<IBridgeController>();
            mUpnpBinaryLightDevices = new BindingList<ZWaveUPnPBinaryLightDevice>();
            mUpnpDevices = new BindingList<ZWaveUPnPDevice>();
            mUPnPMediaRendererDevices = new BindingList<ZWaveUPnPMediaRendererDevice>();
            if (context != null)
            {
                mContext = context;
                mAssociativeDevicesCurrencyManager = (CurrencyManager)context[mAssociativeDevices];
                mAssociativeGroupsCurrencyManager = (CurrencyManager)context[mAssociativeGroups]; 
                mDevicesCurrencyManager = (CurrencyManager)context[mDevices];
                mBridgedDevicesCurrencyManager = (CurrencyManager)context[mBridgedDevices];
                mUpnpBinaryLightDevicesCurrencyManager = (CurrencyManager)context[mUpnpBinaryLightDevices];
                mUpnpDevicesCurrencyManager = (CurrencyManager)context[mUpnpDevices];
                mUPnPMediaRendererDevicesCurrencyManager = (CurrencyManager)context[mUPnPMediaRendererDevices];
            }
        }

        public void SetDocumentModelStateChanged()
        {
            if (DocumentModelStateChanged != null)
                DocumentModelStateChanged(this, EventArgs.Empty);
        }

        #region Devices (nodes)
        private ThreadedBindingList<IDeviceInfo> mDevices;
        public ThreadedBindingList<IDeviceInfo> Devices
        {
            get { return mDevices; }
            set { mDevices = value; }
        }

        private CurrencyManager mDevicesCurrencyManager;
        public CurrencyManager DevicesCurrencyManager
        {
            get { return mDevicesCurrencyManager; }
        }

        public IDeviceInfo CurrentDevice
        {
            get
            {
                if (mDevicesCurrencyManager.Position != -1)
                {
                    return (IDeviceInfo)mDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region AssociativeDevices
        private ThreadedBindingList<IDeviceInfo> mAssociativeDevices;
        public ThreadedBindingList<IDeviceInfo> AssociativeDevices
        {
            get { return mAssociativeDevices; }
            set { mAssociativeDevices = value; }
        }

        private CurrencyManager mAssociativeDevicesCurrencyManager;
        public CurrencyManager AssociativeDevicesCurrencyManager
        {
            get { return mAssociativeDevicesCurrencyManager; }
        }

        public IDeviceInfo CurrentAssociativeDevice
        {
            get
            {
                if (mAssociativeDevicesCurrencyManager.Position != -1)
                {
                    return (IDeviceInfo)mAssociativeDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region AssociativeGroups
        private ThreadedBindingList<AssociativeGroup> mAssociativeGroups;
        public ThreadedBindingList<AssociativeGroup> AssociativeGroups
        {
            get { return mAssociativeGroups; }
            set { mAssociativeGroups = value; }
        }

        private CurrencyManager mAssociativeGroupsCurrencyManager;
        public CurrencyManager AssociativeGroupsCurrencyManager
        {
            get { return mAssociativeGroupsCurrencyManager; }
        }

        public AssociativeGroup CurrentAssociativeGroup
        {
            get
            {
                if (mAssociativeGroupsCurrencyManager.Position != -1)
                {
                    return (AssociativeGroup)mAssociativeGroupsCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region Bridged Devices 
        private BindingList<BridgedDevice> mBridgedDevices;
        public BindingList<BridgedDevice> BridgedDevices
        {
            get { return mBridgedDevices; }
            set { mBridgedDevices = value; }
        }

        private CurrencyManager mBridgedDevicesCurrencyManager;
        public CurrencyManager BridgedDevicesCurrencyManager
        {
            get { return mBridgedDevicesCurrencyManager; }
        }

        public BridgedDevice CurrentBridgedDevice
        {
            get
            {
                if (mBridgedDevicesCurrencyManager.Position != -1)
                {
                    return (BridgedDevice)mBridgedDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region Controllers (bridge controller)
        private BindingList<IBridgeController> mControllers;
        public BindingList<IBridgeController> Controllers
        {
            get { return mControllers; }
        }
        
        public IBridgeController Controller
        {
            get
            {
                if (mControllers.Count > 0)
                {
                    return mControllers[0];
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        internal void RemoveDevice(byte deviceId)
        {
            lock (mDevices)
            {
                IDeviceInfo deviceForDelete = null;
                foreach (IDeviceInfo device in mDevices)
                {
                    if (device.Id == deviceId)
                    {
                        deviceForDelete = device;
                    }
                }
                if (deviceForDelete != null)
                {
                    mDevices.Remove(deviceForDelete);
                }
            }
        }
        internal void RemoveAssociativeDevice(byte deviceId)
        {
            lock (mDevices)
            {
                IDeviceInfo deviceForDelete = null;
                foreach (IDeviceInfo device in mAssociativeDevices)
                {
                    if (device.Id == deviceId)
                    {
                        deviceForDelete = device;
                    }
                }
                if (deviceForDelete != null)
                {
                    mAssociativeDevices.Remove(deviceForDelete);
                }
            }
        }

        public AssociativeGroup CreateAssociativeGroup()
        {
            AssociativeGroup ret = new AssociativeGroup(mContext);
            return ret;
        }

        private byte[] mExternalCommandClassesStorage = new byte[2000];
        /// <summary>
        /// Gets the external storage.
        /// </summary>
        /// <value>The external storage.</value>
        public byte[] ExternalCommandClassesStorage
        {
            get { return mExternalCommandClassesStorage; }
            set { mExternalCommandClassesStorage = value; }
        }

        public void CommandClassesStore_PutExternalStorageBuffer(uint offset, byte[] buffer, uint length)
        {
            for (uint i = offset; i < offset + length; i++)
            {
                mExternalCommandClassesStorage[i] = buffer[i - offset];
            }
        }

        public byte[] CommandClassesStore_GetExternalStorageBuffer(uint offset, byte length)
        {
            byte[] ret = new byte[length];
            for (uint i = offset; i < offset + length; i++)
            {
                ret[i - offset] = mExternalCommandClassesStorage[i];
            }
            return ret;
        }

        #region UPnP Devices
        private BindingList<ZWaveUPnPDevice> mUpnpDevices;
        public BindingList<ZWaveUPnPDevice> UpnpDevices
        {
            get { return mUpnpDevices; }
            set { mUpnpDevices = value; }
        }

        private CurrencyManager mUpnpDevicesCurrencyManager;
        public CurrencyManager UpnpDevicesCurrencyManager
        {
            get { return mUpnpDevicesCurrencyManager; }
        }

        public ZWaveUPnPDevice CurrentUpnpDevice
        {
            get
            {
                if (mUpnpDevicesCurrencyManager.Position != -1)
                {
                    return (ZWaveUPnPDevice)mUpnpDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region UPnP Binary Light Devices 
        private BindingList<ZWaveUPnPBinaryLightDevice> mUpnpBinaryLightDevices;
        public BindingList<ZWaveUPnPBinaryLightDevice> UpnpBinaryLightDevices
        {
            get { return mUpnpBinaryLightDevices; }
            set { mUpnpBinaryLightDevices = value; }
        }

        private CurrencyManager mUpnpBinaryLightDevicesCurrencyManager;
        public CurrencyManager UpnpBinaryLightDevicesCurrencyManager
        {
            get { return mUpnpBinaryLightDevicesCurrencyManager; }
        }

        public ZWaveUPnPBinaryLightDevice CurrentUpnpBinaryLightDevice
        {
            get
            {
                if (mUpnpBinaryLightDevicesCurrencyManager.Position != -1)
                {
                    return (ZWaveUPnPBinaryLightDevice)mUpnpBinaryLightDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion
                
        #region UPnP Media Renderer Devices
        private BindingList<ZWaveUPnPMediaRendererDevice> mUPnPMediaRendererDevices;
        public BindingList<ZWaveUPnPMediaRendererDevice> UPnPMediaRendererDevices
        {
            get { return mUPnPMediaRendererDevices; }
            set { mUPnPMediaRendererDevices = value; }
        }

        private CurrencyManager mUPnPMediaRendererDevicesCurrencyManager;
        public CurrencyManager UPnPMediaRendererDevicesCurrencyManager
        {
            get { return mUPnPMediaRendererDevicesCurrencyManager; }
        }

        public ZWaveUPnPMediaRendererDevice CurrentUPnPMediaRendererDevice
        {
            get
            {
                if (mUPnPMediaRendererDevicesCurrencyManager.Position != -1)
                {
                    return (ZWaveUPnPMediaRendererDevice)mUPnPMediaRendererDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion
    }
}
