using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.ZWave.UPnPBridge.Models;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class ControllerFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load += new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.vcBtnLoadCClassesFromDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.vcBtnSaveCClassesToDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);


            form.vcSucRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.vcSisRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.vcNoneRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click += new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }



        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load -= new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.vcBtnLoadCClassesFromDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.vcBtnSaveCClassesToDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);

            form.vcSucRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.vcSisRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.vcNoneRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click -= new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
