using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using System.Threading;
using Zensys.ZWave.Devices;
using OpenSource.UPnP;
using Zensys.Framework.UI.Controls;
using OpenSource.UPnP.AV;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class UPnPRendererCPActions: BaseAction
    {
        private UPnPSmartControlPoint scp;
        public UPnPRendererCPActions(ControllerManager controller) : base(controller) { }

        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.ItemColumns.Clear();
            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.ItemColumns.Add(new ItemColumn("FriendlyName", new string[] { "FriendlyName" }, OnGetTextFriendlyName, null));
            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.ItemColumns.Add(new ItemColumn("StandardDeviceType", new string[] { "StandardDeviceType" }, OnGetTextStandardDeviceType, null));
            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.ItemColumns.Add(new ItemColumn("Version", new string[] { "Version" }, OnGetTextVersion, null));
            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.ItemColumns.Add(new ItemColumn("PresentationURL", new string[] { "PresentationURL" }, OnGetTextPresentationURL, null));

            ControllerManager.UPnPRendererCPForm.LabelStateText.DataBindings.Add("Text", ControllerManager.DocumentModel.UPnPMediaRendererDevices, "State");
            ControllerManager.UPnPRendererCPForm.LabelStatusText.DataBindings.Add("Text", ControllerManager.DocumentModel.UPnPMediaRendererDevices, "Status");
            ControllerManager.UPnPRendererCPForm.LabelTitleText.DataBindings.Add("Text", ControllerManager.DocumentModel.UPnPMediaRendererDevices, "Title"); 

            scp = new UPnPSmartControlPoint(OnAddSink, "urn:schemas-upnp-org:device:MediaRenderer:1");
            scp.OnRemovedDevice += OnRemoveSink;

            ControllerManager.UPnPRendererCPForm.ListViewUPnPMediaRenderer.DataSource = ControllerManager.DocumentModel.UPnPMediaRendererDevices;
            ControllerManager.DocumentModel.UPnPMediaRendererDevicesCurrencyManager.CurrentChanged += new EventHandler(UPnPMediaRendererDevicesCurrencyManagerCurrentChanged);
            OnDocumentModelStateChanged();
        }

        private string OnGetTextFriendlyName(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextStandardDeviceType(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextVersion(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextPresentationURL(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }

        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            scp.OnRemovedDevice -= OnRemoveSink;
            ControllerManager.DocumentModel.UPnPMediaRendererDevicesCurrencyManager.CurrentChanged -= new EventHandler(UPnPMediaRendererDevicesCurrencyManagerCurrentChanged);
            ControllerManager.MainForm.UPnPRendererCPToolStripMenuItem.Checked = false;
            ControllerManager.UPnPRendererCPForm.Hide();
            e.Cancel = true;
        }

        private void OnDocumentModelStateChanged()
        {

        }

        private void UPnPMediaRendererDevicesCurrencyManagerCurrentChanged(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
               ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.GetTransportInfo(0);
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.GetPositionInfo(0);
            }
            OnDocumentModelStateChanged();
        }

        private void OnAddSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ZWaveUPnPMediaRendererDevice device = new ZWaveUPnPMediaRendererDevice(d);
            UPnPService[] services = d.GetServices(CpRenderingControl.SERVICE_NAME);
            if (services != null && services.Length > 0)
            {
                device.RenderingControl = new CpRenderingControl(services[0]);
            }
            services = d.GetServices(CpConnectionManager.SERVICE_NAME);
            if (services != null && services.Length > 0)
            {
                device.ConnectionManager = new CpConnectionManager(services[0]);
            }
            services = d.GetServices(CpAVTransport.SERVICE_NAME);
            if (services != null && services.Length > 0)
            {
                device.AVTransport = new CpAVTransport(services[0]);
                device.AVTransport.OnResult_GetPositionInfo += new CpAVTransport.Delegate_OnResult_GetPositionInfo(AVTransport_OnResult_GetPositionInfo);
                device.AVTransport.OnResult_GetTransportInfo += new CpAVTransport.Delegate_OnResult_GetTransportInfo(AVTransport_OnResult_GetTransportInfo);
                device.AVTransport.OnStateVariable_LastChange += new CpAVTransport.StateVariableModifiedHandler_LastChange(AVTransport_OnStateVariable_LastChange);
                device.AVTransport._subscribe(300);
            }


            ControllerManager.DocumentModel.UPnPMediaRendererDevices.Add(device);
        }

        void AVTransport_OnStateVariable_LastChange(CpAVTransport sender, string NewValue)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
               ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.GetTransportInfo(0);
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.GetPositionInfo(0);
            }
        }

        void AVTransport_OnResult_GetTransportInfo(CpAVTransport sender, uint InstanceID, CpAVTransport.Enum_TransportState CurrentTransportState, CpAVTransport.Enum_TransportStatus CurrentTransportStatus, CpAVTransport.Enum_TransportPlaySpeed CurrentSpeed, UPnPInvokeException e, object _Tag)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
               ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.State = CurrentTransportState.ToString();
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.Status = CurrentTransportStatus.ToString();
                ControllerManager.DocumentModel.UPnPMediaRendererDevices.ResetItem(ControllerManager.DocumentModel.UPnPMediaRendererDevicesCurrencyManager.Position);
            }
        }

        void AVTransport_OnResult_GetPositionInfo(CpAVTransport sender, uint InstanceID, uint Track, string TrackDuration, string TrackMetaData, string TrackURI, string RelTime, string AbsTime, int RelCount, int AbsCount, UPnPInvokeException e, object _Tag)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
               ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.Title = TrackURI;
                ControllerManager.DocumentModel.UPnPMediaRendererDevices.ResetItem(ControllerManager.DocumentModel.UPnPMediaRendererDevicesCurrencyManager.Position);
            }
        }

        private void OnRemoveSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ZWaveUPnPMediaRendererDevice forRemove = null;
            foreach (ZWaveUPnPMediaRendererDevice var in ControllerManager.DocumentModel.UPnPMediaRendererDevices)
            {
                if (var.UPnPDevice.UniqueDeviceName == d.UniqueDeviceName)
                {
                    forRemove = var;
                    break;
                }
            }

            if (forRemove != null)
            {
                ControllerManager.DocumentModel.UPnPMediaRendererDevices.Remove(forRemove);
            }
            ControllerManager.DocumentModel.UPnPMediaRendererDevices.ResetBindings();
        }      

        public void OnButtonReScanClick(object sender, EventArgs e)
        {
            scp.Rescan();
        }

        public void OnButtonPlayClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null && 
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.Play(0, CpAVTransport.Enum_TransportPlaySpeed._1);
                //m_log.Write(friendlyName + " received Play command");
            }
            else
            {
                //m_log.Write(friendlyName + " has no properly recognized connection to receive the Play command");
            }
        
        }

        public void OnButtonPauseClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.Pause(0);
            }
            else
            {
                //mainLog.Write("Before Pause can be executed select a Renderer");
            }
        }

        public void OnButtonStopClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.Stop(0);
            }
            else
            {
                //mainLog.Write("Before Stop can be executed select a Renderer");
            }
        }

        public void OnButtonPrevClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.Previous(0);
            }
            else
            {
                //mainLog.Write("Before Prev can be executed select a Renderer");
            }
        }

        public void OnButtonNextClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice != null &&
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport != null)
            {
                ControllerManager.DocumentModel.CurrentUPnPMediaRendererDevice.AVTransport.Next(0);
            }
            else
            {
                //mainLog.Write("Before Next can be executed select a Renderer");
            }
        }
    }
}
