using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using System.Threading;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using System.Windows.Forms;
using OpenSource.UPnP;
using Zensys.Framework.UI.Controls;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class UPnPDeviceScannerActions: BaseAction
    {
        private UPnPSmartControlPoint scp;
        public UPnPDeviceScannerActions(ControllerManager controller) : base(controller) { }

        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.ItemColumns.Clear();
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.ItemColumns.Add(new ItemColumn("FriendlyName", new string[] { "FriendlyName" }, OnGetTextFriendlyName, null));
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.ItemColumns.Add(new ItemColumn("StandardDeviceType", new string[] { "StandardDeviceType" }, OnGetTextStandardDeviceType, null));
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.ItemColumns.Add(new ItemColumn("Version", new string[] { "Version" }, OnGetTextVersion, null));
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.ItemColumns.Add(new ItemColumn("PresentationURL", new string[] { "PresentationURL" }, OnGetTextPresentationURL, null));

            scp = new UPnPSmartControlPoint(OnAddSink, null, "upnp:rootdevice");
            scp.OnRemovedDevice += OnRemoveSink;
            ControllerManager.UPnPDeviceScannerForm.ListViewUPnPDevices.DataSource = ControllerManager.DocumentModel.UpnpDevices;
            ControllerManager.DocumentModel.UpnpDevicesCurrencyManager.CurrentChanged += new EventHandler(UpnpDevicesCurrencyManagerCurrentChanged);
            OnDocumentModelStateChanged();
        }

        private string OnGetTextFriendlyName(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextStandardDeviceType(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextVersion(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        private string OnGetTextPresentationURL(List<object> dataObjects)
        {
            return dataObjects[0].ToString();
        }
        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            scp.OnRemovedDevice -= OnRemoveSink;
            ControllerManager.DocumentModel.UpnpDevicesCurrencyManager.CurrentChanged -= new EventHandler(UpnpDevicesCurrencyManagerCurrentChanged);
            ControllerManager.MainForm.UPnPDeviceScannerToolStripMenuItem.Checked = false;
            ControllerManager.UPnPDeviceScannerForm.Hide();
            e.Cancel = true;
        }
        
        private void UpnpDevicesCurrencyManagerCurrentChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private void OnDocumentModelStateChanged()
        {

        }

        public void OnButtonDeviceScannerReScanClick(object sender, EventArgs e)
        {
            scp.Rescan();
        }

        private void OnAddSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ControllerManager.DocumentModel.UpnpDevices.Add(new ZWaveUPnPDevice(d));
        }

        private void OnRemoveSink(UPnPSmartControlPoint sender, UPnPDevice d)
        {
            ZWaveUPnPDevice forRemove = null;
            foreach (ZWaveUPnPDevice var in ControllerManager.DocumentModel.UpnpDevices)
            {
                if (var.UPnPDevice.UniqueDeviceName == d.UniqueDeviceName)
                {
                    forRemove = var;
                    break;
                }
            }

            if (forRemove != null)
            {
                ControllerManager.DocumentModel.UpnpDevices.Remove(forRemove);
            }
            ControllerManager.DocumentModel.UpnpDevices.ResetBindings();
        }
    }
}
