using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.Devices;
using Zensys.ZWave.UPnPBridge.Properties;
using Zensys.ZWave.Enums;
using System.Windows.Forms;
using Zensys.ZWave.SerialPortApplication.Devices;
using System.Drawing;
using Zensys.Framework;
using Zensys.ZWave;
using Zensys.Framework.Helpers;
using Zensys.Framework.UI.Controls;
using Zensys.ZWave.UPnPBridge.UPnPClasses;
using Zensys.ZWave.UPnPBridge.UI;
using System.Threading;
using Zensys.ZWave.ZWaveHAL.Actions;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.UPnPBridge.Actions
{
    public class NodeFormActions : BaseAction
    {
        NodesViewActions NodesHAL;
        public NodeFormActions(ControllerManager controller)
            : base(controller)
        {
            NodesHAL = CustomLoader.CreateNodesViewActionsInstance();
            NodesHAL.Initialize(controller.LogManager, controller.ExceptionManager, controller.XmlDataManager);
            NodesHAL.AddQueueCommandCallback = controller.AddQueueCommand;
            NodesHAL.ExecuteQueueCommandCallback = controller.ExecuteQueueCommand;
            NodesHAL.ItemChanged += new EventHandler(NodesHAL_ItemChanged);
            NodesHAL.NodeAdded += new EventHandler<NodeEventArgs>(NodesHAL_NodeAdded);
            base.ActionsHAL = NodesHAL;
        }

        void NodesHAL_NodeAdded(object sender, NodeEventArgs e)
        {
            AddControllerNode(e.Device);
        }

        void NodesHAL_ItemChanged(object sender, EventArgs e)
        {
            int position = -1;
            foreach (IDeviceInfo d in ControllerManager.DocumentModel.Devices)
            {
                position++;
                if (d.Id == ((IDeviceInfo)sender).Id)
                    break;
            }
            if (position > -1)
            {
                ControllerManager.DocumentModel.Devices.ResetItem(position);
            }
        }

        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.NodeForm.nodeGridViewControl.btnBasicToggle.Visible = false;

            ControllerManager.NodeForm.nodeGridViewControl.btnAddVirtualNode.Visible = true;
            ControllerManager.NodeForm.nodeGridViewControl.btnRemoveVirtualNode.Visible = true;
            ControllerManager.NodeForm.nodeGridViewControl.btnTxInfo.Visible = true;
            ControllerManager.NodeForm.nodeGridViewControl.btnTxReset.Visible = true;

            ControllerManager.NodeForm.nodeGridViewControl.btnIsFailed.Visible = false;
            ControllerManager.NodeForm.nodeGridViewControl.btnReplaceFailed.Visible = false;
            ControllerManager.NodeForm.nodeGridViewControl.btnRemoveFailed.Visible = false;
            ControllerManager.NodeForm.nodeGridViewControl.txtWUIValue.Visible = false;
            ControllerManager.NodeForm.nodeGridViewControl.btnWUISet.Visible = false;
            ControllerManager.NodeForm.nodeGridViewControl.btnNodeInfo.Visible = true;


            DataGridViewColumn colNodeId = new DataGridViewTextBoxColumn();
            DataGridViewColumn colNodeType = new DataGridViewTextBoxColumn();
            DataGridViewBitImageColumn colIsListening = new DataGridViewBitImageColumn();
            DataGridViewBitImageColumn colIsVirtual = new DataGridViewBitImageColumn();

            colNodeId.Name = "colId";
            colNodeId.HeaderText = "Id";
            colNodeId.DataPropertyName = "Id";
            colNodeId.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;


            colNodeType.Name = "colType";
            colNodeType.HeaderText = "Type";
            colNodeType.DataPropertyName = "Type";
            colNodeType.MinimumWidth = 100;
            colNodeType.FillWeight = 100;
            colIsListening.AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;

            colIsListening.Name = "colIsListening";
            colIsListening.HeaderText = "Listening";
            colIsListening.DataPropertyName = "IsListening";
            colIsListening.Images = ControllerManager.NodeForm.nodeGridViewControl.Images;
            colIsListening.TrueImageIndex = 0;
            colIsListening.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;
            colNodeType.MinimumWidth = 40;

            colIsVirtual.Name = "colIsVirtual";
            colIsVirtual.HeaderText = "Virtual";
            colIsVirtual.DataPropertyName = "IsVirtual";
            colIsVirtual.Images = ControllerManager.NodeForm.nodeGridViewControl.Images;
            colIsVirtual.TrueImageIndex = 1;
            colIsVirtual.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCellsExceptHeader;
            colNodeType.MinimumWidth = 40;
            ControllerManager.NodeForm.nodeGridViewControl.nodesGridView.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            ControllerManager.NodeForm.nodeGridViewControl.nodesGridView.AutoGenerateColumns = false;
            ControllerManager.NodeForm.nodeGridViewControl.nodesGridView.Columns.AddRange(new DataGridViewColumn[] { colNodeId, colNodeType, colIsListening, colIsVirtual });
            BindData();


            ControllerManager.NodeForm.vcNodeInfoTreeView.ImageList = ControllerManager.NodeForm.nodeGridViewControl.Images;
            ControllerManager.NodeForm.vcNodeInfoTreeView.DataSource = ControllerManager.DocumentModel.Devices;
            ControllerManager.NodeForm.vcNodeInfoTreeView.CreatePrefetchedObject = CreatePrefetchedObject;
            OnDocumentModelStateChanged();
        }

        private void BindData()
        {
            ControllerManager.DocumentModel.Devices.Ctx = SynchronizationContext.Current;
            ControllerManager.NodeForm.nodeGridViewControl.nodesGridView.DataSource = ControllerManager.DocumentModel.Devices;
        }

        private PrefetchedObject CreatePrefetchedObject(object currentObject)
        {
            IDeviceInfo device = (IDeviceInfo)currentObject;
            List<ParamValue> payloadValues = GetNodeInfoPayloadValues(device);
            PrefetchedObject poRoot = new PrefetchedObject();
            poRoot.Text = string.Format("Id: {0}; {1}", device.Id, device.Type);
            poRoot.ImageIndex = 2;
            foreach (ParamValue paramValue in payloadValues)
            {
                List<string> str = paramValue.TextValueList;
                PrefetchedObject po = new PrefetchedObject();
                po.ImageIndex = 3;
                if (paramValue.TextValueList.Count == 1)
                {
                    po.Text = string.Format("{0}: {1}", paramValue.ParamDefinition.Text, paramValue.TextValueList[0]);
                }
                else if (paramValue.TextValueList.Count > 1)
                {
                    po.Text = string.Format("{0}: {1}", paramValue.ParamDefinition.Text, Tools.GetHex(paramValue.ByteValueList.ToArray(), " ", false));
                    foreach (string var in paramValue.TextValueList)
                    {
                        PrefetchedObject subpo = new PrefetchedObject();
                        subpo.Text = var;
                        subpo.ImageIndex = 4;
                        po.Children.Add(subpo);
                    }
                }
                else
                {
                    po.Text = string.Format("{0}: {1}", paramValue.ParamDefinition.Text, Tools.GetHex(paramValue.ByteValueList.ToArray(), " ", false));
                }
                if (!String.IsNullOrEmpty(paramValue.ParamDefinition.GroupName))
                {
                    PrefetchedObject groupPo = FindPrefetchedObject(poRoot, paramValue.ParamDefinition.GroupName);
                    if (groupPo != null)
                    {
                        groupPo.Children.Add(po);
                    }
                    else
                    {
                        groupPo = new PrefetchedObject();
                        groupPo.ImageIndex = 3;
                        groupPo.Text = paramValue.ParamDefinition.GroupName;
                        groupPo.Children.Add(po);
                        poRoot.Children.Add(groupPo);
                    }
                }
                else
                {
                    poRoot.Children.Add(po);
                }
            }

            return poRoot;
        }
        private PrefetchedObject FindPrefetchedObject(PrefetchedObject node, string name)
        {
            PrefetchedObject result = null;
            if (node.Text == name) return node;
            if (node.Children != null && node.Children.Count > 0)
            {
                foreach (PrefetchedObject child in node.Children)
                {
                    result = FindPrefetchedObject(child, name);
                }
            }
            return result;
        }
        private List<ParamValue> GetNodeInfoPayloadValues(IDeviceInfo device)
        {
            CommandClass cmdClass = ControllerManager.XmlDataManager.FindCommandClass("ZWAVE_CMD_CLASS", 1);
            Command cmd = ControllerManager.XmlDataManager.FindCommand("ZWAVE_CMD_CLASS", 1, "NODE_INFO");
            List<byte> payload = new List<byte>();
            payload.Add(cmdClass.KeyId);
            payload.Add(cmd.KeyId);
            payload.AddRange(new byte[] { device.Capability, device.Security, device.Reserved, /*device.Basic,*/ device.Generic, device.Specific });
            if (device.SupportedCommandClasses != null)
            {
                payload.AddRange(device.SupportedCommandClasses);
            }
            CommandClassValue[] cmdClassValues = null;
            ControllerManager.XmlDataManager.ParseApplicationObject(payload.ToArray(), out cmdClassValues);
            if (cmdClassValues != null)
            {
                return cmdClassValues[0].CommandValue.ParamValues;
            }
            return null;
        }

        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            NodeForm form = (NodeForm)sender;
            ControllerManager.DocumentModel.Controllers.ListChanged -= new System.ComponentModel.ListChangedEventHandler(ControllersListChanged);
            ControllerManager.DocumentModel.DevicesCurrencyManager.CurrentChanged -= new EventHandler(DevicesCurrencyManagerCurrentChanged);
            ControllerManager.MainForm.NodeToolStripMenuItem.Checked = false;
            form.Hide();
            e.Cancel = true;
        }
        #endregion

        private void DevicesCurrencyManagerCurrentChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private void ControllersListChanged(object sender, System.ComponentModel.ListChangedEventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        #region DocumentModel
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            NodeForm form = ControllerManager.NodeForm;
            if (form != null && !form.IsDisposed)
            {
                if (form.InvokeRequired)
                {
                    form.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.NodeForm.vcAddNodeToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                        (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0);

                    ControllerManager.NodeForm.vcRemoveNodeToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                      ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                      (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0);

                    ControllerManager.NodeForm.vcNodesListView.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                    ControllerManager.NodeForm.vcNodeInfoTreeView.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                    ControllerManager.NodeForm.vcRemoveFailedNodeToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                      ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                      (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0) &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;

                    ControllerManager.NodeForm.vcIsFailedNodeToolStripButton.Enabled =
                                            ControllerManager.DocumentModel.Controller != null &&
                                            ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;

                    ControllerManager.NodeForm.vcReplaceFailedNodeToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                      ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                      (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0) &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;

                    ControllerManager.NodeForm.vcSetAllOffToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                    ControllerManager.NodeForm.vcSetAllOnToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                    ControllerManager.NodeForm.vcSetOffToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;

                    ControllerManager.NodeForm.vcSetOnToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1;

                    form.vcAddVirtualToolStripButton.Enabled =
                         ControllerManager.DocumentModel.Controller != null &&
                      ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                      (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0);

                    form.vcRemoveVirtualToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.CurrentDevice != null &&
                        ControllerManager.DocumentModel.CurrentDevice.IsVirtual &&
                      ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Secondary) == 0 ||
                      (ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.Inclusion) != 0);

                    form.vcTxInfoToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.CurrentDevice != null &&
                        ControllerManager.DocumentModel.CurrentDevice.IsVirtual;

                    form.vcTxResetToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                    form.vcToolStripMain.Enabled =
                        ControllerManager.DocumentModel.Controller != null;

                }
            }
        }

        #endregion
        List<byte> nodesAddedFailedList = new List<byte>();
        public void AddControllerNode(IDeviceInfo addedNode)
        {
            if (addedNode != null)
            {
                ControllerManager.DocumentModel.RemoveDevice(addedNode.Id);
                if (!nodesAddedFailedList.Contains(addedNode.Id))
                {
                    GenericDevice gd = ControllerManager.XmlDataManager.FindGenericDevice(addedNode.Generic);
                    if (gd != null)
                    {
                        addedNode.Type = (String.IsNullOrEmpty(gd.Text)) ? gd.Name : gd.Text;
                    }
                    else
                    {
                        addedNode.Type = "Generic Device:" + Tools.ToHexString(addedNode.Generic);
                    }
                    ControllerManager.DocumentModel.Devices.Add(addedNode);
                    if (addedNode.SupportedCommandClasses != null &&
                       ControllerManager.DocumentModel.Controller.CommandClassesStore.IsSupported(addedNode.Id,
                       ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_ASSOCIATION")))
                    {
                        ControllerManager.DocumentModel.AssociativeDevices.Add(addedNode);
                    }
                }
            }
            if (addedNode != null && !nodesAddedFailedList.Contains(addedNode.Id))
            {
                ControllerManager.LogManager.LogMessage("Node added to the network...");
            }
            else
            {
                ControllerManager.LogManager.LogMessage("Add Node to the network failed...");
            }
        }

        public void RemoveControllerNode(byte removedNodeId)
        {
            RemoveControllerNodeInternal(removedNodeId);
        }

        private void RemoveControllerNodeInternal(byte removedNodeId)
        {
            if (removedNodeId > 0)
            {
                ControllerManager.DocumentModel.RemoveDevice(removedNodeId);
                if (ControllerManager.DocumentModel.CurrentAssociativeDevice != null && ControllerManager.DocumentModel.CurrentAssociativeDevice.Id == removedNodeId)
                {
                    ControllerManager.DocumentModel.AssociativeGroups.Clear();
                }
                ControllerManager.DocumentModel.RemoveAssociativeDevice(removedNodeId);
            }
        }
        #region Toolbar
        public void OnAddNodeClick(object sender, EventArgs e)
        {
            nodesAddedFailedList.Clear();
            IDeviceInfo addedNode = (IDeviceInfo)ControllerManager.DoAction(
                new FunctionCaller<IDeviceInfo, IController>(NodesHAL.AddNodeAction),
                new object[] { ControllerManager.DocumentModel.Controller },
                Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
        }

        public void OnNetworkWideInclusionClick(object sender, EventArgs e)
        {
            ControllerManager.DoAction(
                new Action<IController>(OnNetworkWideInclusionInner),
                new object[] { ControllerManager.DocumentModel.Controller },
                Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
        }

        public void OnNetworkWideInclusionInner(IController controller)
        {
            nodesAddedFailedList.Clear();
            IDeviceInfo addedNode = null;
            ControllerManager.NetworkWideInclusionCanceled = false;
            while (!ControllerManager.NetworkWideInclusionCanceled)
            {
                addedNode = NodesHAL.NetworkWideInclusionAction(ControllerManager.DocumentModel.Controller);
            }
        }

        public void OnRemoveNodeClick(object sender, EventArgs e)
        {
            byte removedNodeId = (byte)ControllerManager.DoAction(
                new FunctionCaller<byte, IController>(NodesHAL.RemoveNodeAction),
                new object[] { ControllerManager.DocumentModel.Controller },
                Resources.MsgRemoveNode, true, (byte)CommandTypes.CmdZWaveRemoveNodeFromNetwork);
            if (removedNodeId > 0)
            {
                RemoveControllerNode(removedNodeId);
            }
        }
        public void OnNodeInfoClick(object sender, EventArgs e)
        {
            IDeviceInfo device = ControllerManager.DocumentModel.CurrentDevice;
            QueueAction action = new QueueAction(
                            new FunctionCaller<IDeviceInfo, IController, byte, IDeviceInfo>(NodesHAL.NodeInfoAction),
                            new object[] 
                        { 
                    ControllerManager.DocumentModel.Controller, 
                    device.Id, 
                    device },
                         Resources.MsgGetNodeReport, true, (byte)CommandTypes.CmdZWaveRequestNodeInfo, "Request Node Information", 0);

            if (device.IsListening || device.IsCommandQueueOverrided || (device.Security & 0x20) != 0 || (device.Security & 0x40) != 0)
            {
                IDeviceInfo deviceInfo = (IDeviceInfo)ControllerManager.DoAction(action);
                device = deviceInfo;
                //ControllerManager.DocumentModel.Devices.Remove(device);
                //ControllerManager.DocumentModel.Devices.Add(deviceInfo);
            }
            else
            {
                ControllerManager.AddQueueCommand(device.Id, action);
                ControllerManager.LogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Request Node Information", device.Id));
            }
        }
        public void OnSetOnClick(object sender, EventArgs e)
        {
            SendBasicSetOnOff(true, GetSelectedDevices());
        }

        private List<IDeviceInfo> GetSelectedDevices()
        {
            return GetSelectedDevices(false);
        }

        private List<IDeviceInfo> GetSelectedDevices(bool excludeConnectedDevice)
        {
            List<IDeviceInfo> ret = new List<IDeviceInfo>();
            foreach (DataGridViewRow row in ControllerManager.NodeForm.nodeGridViewControl.nodesGridView.SelectedRows)
            {
                IDeviceInfo device = row.DataBoundItem as IDeviceInfo;
                if (device != null)
                {
                    if (!excludeConnectedDevice || device.Id != ControllerManager.DocumentModel.Controller.Id)
                    {
                        ret.Add(device);
                    }
                }
            }
            return ret;
        }
        public void OnSetOffClick(object sender, EventArgs e)
        {
            SendBasicSetOnOff(false, GetSelectedDevices());
        }
        public void OnSetAllOnClick(object sender, EventArgs e)
        {
            SendSwitchOnOff(true);
        }
        public void OnSetAllOffClick(object sender, EventArgs e)
        {
            SendSwitchOnOff(false);
        }
        private void SendSwitchOnOff(bool isOn)
        {
            ControllerManager.DoAction(
              new ProcedureCaller<IController, IList<IDeviceInfo>, bool>(NodesHAL.SendSwitchOnOffAction),
              new object[]{
                  ControllerManager.DocumentModel.Controller,
                  ControllerManager.DocumentModel.Devices,
                  isOn},
              Resources.MsgSetOn, true, (byte)CommandTypes.None);
        }

        private void SendBasicSetOnOff(bool isOn, List<IDeviceInfo> selectedNodes)
        {
            ControllerManager.DoAction(
             new ProcedureCaller<IController, IList<IDeviceInfo>, bool>(NodesHAL.SendBasicSetOnOffAction),
             new object[]{
                  ControllerManager.DocumentModel.Controller,
                  selectedNodes,
                  isOn},
             Resources.MsgSetOn, true, (byte)CommandTypes.None);
        }
        public void OnReplaceFailedNodeClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1)
            {
                byte nodeId = ((IDeviceInfo)ControllerManager.DocumentModel.DevicesCurrencyManager.Current).Id;
                IDeviceInfo replacedNode = (IDeviceInfo)ControllerManager.DoAction(
                   new FunctionCaller<IDeviceInfo, IController, byte>(NodesHAL.ReplaceFailedNodeAction),
                   new object[] { ControllerManager.DocumentModel.Controller, nodeId },
                   Resources.MsgReplaceFailedNode, true, (byte)CommandTypes.None);
                if (replacedNode != null)
                {
                    ControllerManager.NodeForm.nodeGridViewControl.UnMarkFailedNode(replacedNode.Id);
                    AddControllerNode(replacedNode);
                }
            }
        }
        public void OnIsFailedNodeClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1)
            {
                byte nodeId = ((IDeviceInfo)ControllerManager.DocumentModel.DevicesCurrencyManager.Current).Id;
                bool isFailed = (bool)ControllerManager.DoAction(
                new FunctionCaller<bool, IController, byte>(NodesHAL.IsFailedNodeAction),
                new object[] { ControllerManager.DocumentModel.Controller, nodeId },
                Resources.MsgIsFailedNode, true, (byte)CommandTypes.None);
                if (isFailed)
                {
                    ControllerManager.NodeForm.nodeGridViewControl.MarkFailedNode(nodeId);
                }
            }
        }
        public void OnRemoveFailedNodeClick(object sender, EventArgs e)
        {
            if (ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1)
            {
                byte nodeId = ((IDeviceInfo)ControllerManager.DocumentModel.DevicesCurrencyManager.Current).Id;
                bool removedNode = (bool)ControllerManager.DoAction(
                   new FunctionCaller<bool, IController, byte>(NodesHAL.RemoveFailedNodeAction),
                   new object[] { ControllerManager.DocumentModel.Controller, nodeId },
                   Resources.MsgRemoveFailedNode, true, (byte)CommandTypes.CmdZWaveRemoveNodeFromNetwork);
                if (removedNode)
                {
                    RemoveControllerNodeInternal(nodeId);
                }
            }
        }
        public void OnSetWakeUpIntervalClick(object sender, EventArgs e)
        {
            int wakeUpInterval = int.Parse(ControllerManager.NodeForm.vcWakeUpIntervalToolStripTextBox.Text);
            if (wakeUpInterval > 0 && wakeUpInterval < 279620)
            {
                QueueAction action = (QueueAction)ControllerManager.DoAction(
                    new FunctionCaller<QueueAction, IController, IDeviceInfo, string, int>(NodesHAL.SetWakeUpIntervalAction),
                    new object[] { 
                        ControllerManager.DocumentModel.Controller,
                        ControllerManager.DocumentModel.CurrentDevice, 
                        Resources.MsgSetWakeUpInterval,
                        wakeUpInterval},
                   Resources.MsgSetWakeUpInterval, true, (byte)CommandTypes.None);
                if (action != null)
                {
                    ControllerManager.AddQueueCommand(ControllerManager.DocumentModel.CurrentDevice.Id, action);
                    ControllerManager.LogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Set Wake Up Interval", ControllerManager.DocumentModel.CurrentDevice.Id));
                }
            }
        }

        public void OnBasicToggleToolStripButtonClick(object sender, EventArgs e)
        {
            List<IDeviceInfo> nodes = GetSelectedDevices(true);
            ControllerManager.DoAction(
              new ProcedureCaller<IController, IList<IDeviceInfo>, bool>(NodesHAL.BasicGetAction),
              new object[]{
                  ControllerManager.DocumentModel.Controller,
                  nodes,
                  ControllerManager.NodeForm.vcBasicToggleToolStripButton.Checked},
              Resources.MsgSetOn, true, (byte)CommandTypes.None);
        }

        public void OnNopToolStripButtonClick(object sender, EventArgs e)
        {
            IDeviceInfo device = null;
            byte nodeId = 0;
            if (!byte.TryParse(ControllerManager.NodeForm.vcNopIDToolStripNumericTextBox.Text, out nodeId) || nodeId == 0)
            {
                if (ControllerManager.DocumentModel.DevicesCurrencyManager.Position > -1)
                {
                    nodeId = ControllerManager.DocumentModel.CurrentDevice.Id;
                    device = ControllerManager.DocumentModel.CurrentDevice;
                }
            }
            else
            {
                foreach (IDeviceInfo d in ControllerManager.DocumentModel.Devices)
                {
                    if (d.Id == nodeId)
                    {
                        device = d;
                        break;
                    }
                }
            }
            if (nodeId > 0)
            {
                QueueAction action = new QueueAction(
                    new ProcedureCaller<IController, byte, string>(NodesHAL.NopAction),
                    new object[] { ControllerManager.DocumentModel.Controller, nodeId, Resources.ErrNopSendFail },
                    Resources.MsgSendNop, true, (byte)CommandTypes.None, "NOP", 0);

                if (device == null || device.IsListening || (device.Security & 0x20) != 0 || (device.Security & 0x40) != 0)
                {
                    IDeviceInfo infoNode = (IDeviceInfo)ControllerManager.DoAction(action);
                }
                else
                {
                    ControllerManager.AddQueueCommand(device.Id, action);
                    ControllerManager.LogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "NOP", device.Id));
                }
            }
        }
        public void OnAddVirtualClick(object sender, EventArgs e)
        {
            IDeviceInfo addedNode = null;
            ControllerManager.DoAction(new EventHandler(delegate
               {
                   IBridgeController device = ControllerManager.DocumentModel.Controller;
                   try
                   {
                       if (device.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                       {
                           device.Open(device.SerialPort);
                       }
                       ControllerManager.Actions.LogFormActions.WriteMessage("Add virtual Node to network started...");

                       device.SetSlaveNodeInformation(
                           0x00,
                           true,
                           ControllerManager.XmlDataManager.GetGenericDeviceKey("GENERIC_TYPE_SWITCH_MULTILEVEL"),
                           ControllerManager.XmlDataManager.FindSpecificDevice("GENERIC_TYPE_SWITCH_MULTILEVEL", "SPECIFIC_TYPE_POWER_SWITCH_MULTILEVEL").KeyId,
                           new byte[] { 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_MULTILEVEL"), 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL") });

                       ControllerManager.DocumentModel.Controller.ControllerUpdated -= new Zensys.ZWave.Events.ControllerUpdatedEventHandler(ControllerManager.Actions.ControllerFormActions.ControllerUpdated);
                       byte[] res = device.SetSlaveLearnMode(0, SlaveLearnMode.VirtualSlaveLearnModeAdd);
                       if (res != null && res.Length == 4)
                       {
                           byte status = res[1];
                           byte orgId = res[2];
                           byte newId = res[3];
                           if (newId != 0)
                           {
                               addedNode = device.GetProtocolInfo(newId, false);
                               addedNode.IsVirtual = true;
                               addedNode.SupportedCommandClasses = new byte[2];
                               addedNode.SupportedCommandClasses[0] = ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_MULTILEVEL");
                               addedNode.SupportedCommandClasses[1] = ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL");
                               if (addedNode.SupportedCommandClasses != null)
                               {
                                   foreach (byte b in addedNode.SupportedCommandClasses)
                                   {
                                       ControllerManager.DocumentModel.Controller.CommandClassesStore.Store(addedNode.Id, b);
                                   }
                               }
                               AddControllerNode(addedNode);
                           }
                       }
                       ControllerManager.DocumentModel.Controller.ControllerUpdated += new Zensys.ZWave.Events.ControllerUpdatedEventHandler(ControllerManager.Actions.ControllerFormActions.ControllerUpdated);
                   }
                   catch (Exception ex)
                   {
                       throw ex;
                       //System.Diagnostics.Debug.WriteLine(ex.Message);
                   }

               }), null, Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
            if (addedNode != null)
            {
                ControllerManager.Actions.LogFormActions.WriteMessage("Virtual Node added to the network...");
            }
            else
            {
                ControllerManager.Actions.LogFormActions.WriteMessage("Add virtual Node to network failed...");
            }
        }
        public void OnRemoveVirtualClick(object sender, EventArgs e)
        {
            byte deviceIdForDelete = 0;
            ControllerManager.DoAction(new EventHandler(delegate
               {
                   IBridgeController device = ControllerManager.DocumentModel.Controller;
                   try
                   {
                       if (device.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                       {
                           device.Open(device.SerialPort);
                       }
                       ControllerManager.Actions.LogFormActions.WriteMessage("Remove virtual Node from network started...");
                       byte[] res = device.SetSlaveLearnMode(ControllerManager.DocumentModel.CurrentDevice.Id, SlaveLearnMode.VirtualSlaveLearnModeRemove);
                       if (res != null && res.Length == 4)
                       {
                           byte status = res[1];
                           byte orgId = res[2];
                           byte newId = res[3];
                           if (newId == 0)
                           {
                               deviceIdForDelete = orgId;
                               RemoveControllerNode(orgId);
                           }
                       }

                   }
                   catch (Exception ex)
                   {
                       throw ex;
                       //System.Diagnostics.Debug.WriteLine(ex.Message);
                   }

               }), null, Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
            if (deviceIdForDelete != 0)
            {
                ControllerManager.Actions.LogFormActions.WriteMessage("Virtual Node removed from the network...");
            }
            else
            {
                ControllerManager.Actions.LogFormActions.WriteMessage("Remove virtual Node from network failed...");
            }
        }

        private System.Threading.Timer sendInfoTimer = null;
        private void OnLearnTimer(object nodeID)
        {
            // Stop timer - if any
            if (sendInfoTimer != null)
            {
                sendInfoTimer.Dispose();
            }
            if (nodeID != null)
            {
                ControllerManager.DocumentModel.Controller.SetSlaveLearnMode((byte)nodeID, SlaveLearnMode.VirtualSlaveLearnModeDisable);
            }
            else
            {
                ControllerManager.DocumentModel.Controller.SetSlaveLearnMode(0x00, SlaveLearnMode.VirtualSlaveLearnModeDisable);
            }
        }

        public void OnTxInfoClick(object sender, EventArgs e)
        {
            ControllerManager.DoAction(new EventHandler(delegate
               {
                   IBridgeController device = ControllerManager.DocumentModel.Controller;
                   try
                   {
                       if (device.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                       {
                           device.Open(device.SerialPort);
                       }
                       ControllerManager.Actions.LogFormActions.WriteMessage("Transmit virtual Node Info...");
                       device.SetSlaveNodeInformation(
                           ControllerManager.DocumentModel.CurrentDevice.Id,
                           true,
                           ControllerManager.XmlDataManager.GetGenericDeviceKey("GENERIC_TYPE_SWITCH_MULTILEVEL"),
                           ControllerManager.XmlDataManager.FindSpecificDevice("GENERIC_TYPE_SWITCH_MULTILEVEL", "SPECIFIC_TYPE_POWER_SWITCH_MULTILEVEL").KeyId,
                           new byte[] { 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_MULTILEVEL"), 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL") });
                       byte newNodeId = device.SetSlaveLearnModeEnableAndTx(ControllerManager.DocumentModel.CurrentDevice.Id);
                       if (newNodeId == 0xFF)
                       {
                           if (sendInfoTimer != null)
                           {
                               sendInfoTimer.Dispose();
                           }
                           sendInfoTimer = new System.Threading.Timer(new TimerCallback(this.OnLearnTimer), ControllerManager.DocumentModel.CurrentDevice.Id, 2000, System.Threading.Timeout.Infinite);
                       }
                       else if (newNodeId == 0)
                       {
                           RemoveControllerNode(ControllerManager.DocumentModel.CurrentDevice.Id);
                       }
                   }
                   catch (Exception ex)
                   {
                       throw ex;
                       //System.Diagnostics.Debug.WriteLine(ex.Message);
                   }

               }), null, Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
        }

        public void OnTxResetClick(object sender, EventArgs e)
        {
            ControllerManager.DoAction(new EventHandler(delegate
                 {
                     IBridgeController device = ControllerManager.DocumentModel.Controller;
                     try
                     {
                         if (device.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                         {
                             device.Open(device.SerialPort);
                         }
                         ControllerManager.Actions.LogFormActions.WriteMessage("Transmit reset virtual Node...");
                         device.SetSlaveNodeInformation(
                             0x00, 
                             true,
                             ControllerManager.XmlDataManager.GetGenericDeviceKey("GENERIC_TYPE_SWITCH_MULTILEVEL"),
                             ControllerManager.XmlDataManager.FindSpecificDevice("GENERIC_TYPE_SWITCH_MULTILEVEL", "SPECIFIC_TYPE_POWER_SWITCH_MULTILEVEL").KeyId,
                             new byte[] { 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_MULTILEVEL"), 
                               ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL") });
                         byte newNodeId = device.SetSlaveLearnModeEnableAndTx(0x00);
                         if (newNodeId == 0xFF)
                         {
                             if (sendInfoTimer != null)
                             {
                                 sendInfoTimer.Dispose();
                             }
                             sendInfoTimer = new System.Threading.Timer(new TimerCallback(this.OnLearnTimer), null, 2000, System.Threading.Timeout.Infinite);
                         }
                         else if (newNodeId != 0)
                         {
                             IDeviceInfo addedNode = device.GetProtocolInfo(newNodeId, false);
                             addedNode.IsVirtual = true;
                             addedNode.SupportedCommandClasses = new byte[2];
                             addedNode.SupportedCommandClasses[0] = ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_MULTILEVEL");
                             addedNode.SupportedCommandClasses[1] = ControllerManager.XmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL");
                             if (addedNode.SupportedCommandClasses != null)
                             {
                                 foreach (byte b in addedNode.SupportedCommandClasses)
                                 {
                                     ControllerManager.DocumentModel.Controller.CommandClassesStore.Store(addedNode.Id, b);
                                 }
                             }
                             AddControllerNode(addedNode);
                         }
                     }
                     catch (Exception ex)
                     {
                         throw ex;
                         //System.Diagnostics.Debug.WriteLine(ex.Message);
                     }

                 }), null, Resources.MsgAddNode, true, (byte)CommandTypes.CmdZWaveAddNodeToNetwork);
        }

        #endregion
        public void Devices_ListChanged(object sender, System.ComponentModel.ListChangedEventArgs e)
        {
            OnDocumentModelStateChanged();
        }
        public void DevicesCurrencyManager_PositionChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        public void OnControllerNodeStatusChanged(Zensys.ZWave.Events.NodeStatusChangedEventArgs args)
        {
            ControllerManager.MainForm.LabelStatusText = args.Status.ToString();
            switch (args.Status)
            {
                case NodeStatuses.AddingRemovingController:
                    break;
                case NodeStatuses.AddingRemovingSlave:
                    break;
                case NodeStatuses.Done:
                    break;
                case NodeStatuses.Failed:
                    ControllerManager.LogManager.LogOperationFailure(string.Format("NodesStatuses.Failed received Node:{0}...", args.SourceNodeId));
                    nodesAddedFailedList.Add(args.SourceNodeId);
                    break;
                case NodeStatuses.LearnReady:
                    break;
                case NodeStatuses.NodeFound:
                    break;
                case NodeStatuses.ProtocolDone:
                    break;
                case NodeStatuses.Unknown:
                    break;
                default:
                    break;
            }
        }
    }
}