using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.PCController.Classes;
using Zensys.PCController.Interfaces;
using WeifenLuo.WinFormsUI.Docking;
using Zensys.PCController.Controls;
using Zensys.Framework.UI.Controls;

namespace Zensys.PCController.UI
{
    public partial class NodeForm : DockableView
    {
        public NodeForm()
        {
            DoubleBuffered = true;
            InitializeComponent();
            mvcRequestNodeNeighborUpdateToolStripButton = new ToolStripButton();
            // 
            // mvcRequestNodeNeighborUpdateToolStripButton
            // 
            mvcRequestNodeNeighborUpdateToolStripButton.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            mvcRequestNodeNeighborUpdateToolStripButton.Image = Properties.Resources.RadialChartHS;
            mvcRequestNodeNeighborUpdateToolStripButton.ImageTransparentColor = System.Drawing.Color.Magenta;
            mvcRequestNodeNeighborUpdateToolStripButton.Name = "mvcRequestNodeNeighborUpdateToolStripButton";
            mvcRequestNodeNeighborUpdateToolStripButton.Size = new System.Drawing.Size(23, 22);
            mvcRequestNodeNeighborUpdateToolStripButton.Text = "Request Node Neighbor Update";

            nodeGridViewControl.mainStrip.Items.Insert(4, mvcRequestNodeNeighborUpdateToolStripButton);
        }
        #region View Members

        public System.Windows.Forms.ToolStrip vcToolStripMain
        {
            get { return nodeGridViewControl.mainStrip; }
        }
        private System.Windows.Forms.ToolStripButton mvcRequestNodeNeighborUpdateToolStripButton;
        public System.Windows.Forms.ToolStripButton vcRequestNodeNeighborUpdateToolStripButton
        {
            get { return mvcRequestNodeNeighborUpdateToolStripButton; }
        }
        public System.Windows.Forms.ToolStripButton vcAddNodeNetworkWideToolStripButton
        {
            get { return nodeGridViewControl.btnNWInclusion; }
        }
        public System.Windows.Forms.ToolStripButton vcAddNodeToolStripButton
        {
            get { return nodeGridViewControl.btnAdd; }
        }
        public System.Windows.Forms.ToolStripButton vcRemoveNodeToolStripButton
        {
            get { return nodeGridViewControl.btnRemove; }
        }
        public System.Windows.Forms.ToolStripButton vcNodeInfoToolStripButton
        {
            get { return nodeGridViewControl.btnNodeInfo; }
        }
        public System.Windows.Forms.ToolStripButton vcSetOnToolStripButton
        {
            get { return nodeGridViewControl.btnOn; }
        }
        public System.Windows.Forms.ToolStripButton vcSetOffToolStripButton
        {
            get { return nodeGridViewControl.btnOff; }
        }
        public System.Windows.Forms.ToolStripButton vcReplaceFailedNodeToolStripButton
        {
            get { return nodeGridViewControl.btnReplaceFailed; }
        }
        public System.Windows.Forms.ToolStripButton vcRemoveFailedNodeToolStripButton
        {
            get { return nodeGridViewControl.btnRemoveFailed; }
        }

        public TreeInfoView vcNodeInfoTreeView
        {
            get { return nodeGridViewControl.treeInfoView1; }
        }

        public DataGridView vcNodesListView
        {
            get { return nodeGridViewControl.nodesGridView; }
        }
        
        public System.Windows.Forms.ToolStripButton vcSetAllOnToolStripButton
        {
            get { return nodeGridViewControl.btnAllOn; }
        }
        
        public System.Windows.Forms.ToolStripButton vcSetAllOffToolStripButton
        {
            get { return nodeGridViewControl.btnAllOff; }
        }

        public ToolStripNumericTextBox vcWakeUpIntervalToolStripTextBox
        {
            get { return nodeGridViewControl.txtWUIValue; }
        }

        public System.Windows.Forms.ToolStripButton vcSetWakeUpIntervalToolStripButton
        {
            get { return nodeGridViewControl.btnWUISet; }
        }
        public System.Windows.Forms.ToolStripButton vcIsFailedNodeToolStripButton
        {
            get { return nodeGridViewControl.btnIsFailed; }
        }
        public System.Windows.Forms.ToolStripButton vcNopToolStripButton
		{
            get { return nodeGridViewControl.btnNOP; }
		}
		public ToolStripNumericTextBox vcNopIDToolStripNumericTextBox
		{
            get { return nodeGridViewControl.txtNOPId; }
		}
        public System.Windows.Forms.ToolStripButton vcBasicToggleToolStripButton
        {
            get { return nodeGridViewControl.btnBasicToggle; }
        }
        
        public System.Windows.Forms.ToolStripDropDownButton vcSetSucSisToolStripButton
        {
            get { return nodeGridViewControl.btndSetSUC; }
        }

        public System.Windows.Forms.ToolStripMenuItem vcSetSucToolStripMenuItem
        {
            get { return nodeGridViewControl.setAsSUCToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem vcSetSisToolStripMenuItem
        {
            get { return nodeGridViewControl.setAsSISToolStripMenuItem; }
        }
        #endregion
    }
}