using System;
using System.Collections.Generic;
using System.Text;
using Zensys.Framework;

namespace Zensys.PCController.Models
{
    public class TopologyMapItemCollection : ObservableCollection<TopologyMapItem>
    {
        public void RemoveByDeviceId(byte id)
        {
            TopologyMapItem removeItem = this.FindByDeviceId(id);
            if (removeItem != null)
            {
                this.Remove(removeItem);
            }
        }

        private TopologyMapItem FindByDeviceId(byte id)
        {
            TopologyMapItem result = null;
            foreach (TopologyMapItem item in this.Items)
            {
                if (item.Device != null && item.Device.Id == id)
                {
                    result = item;
                    break;
                }
            }
            return result;
        }
    }
}
