using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class ControllerFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load += new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click += new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.controllerViewControl.vcBtnLoadCClassesFromDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.controllerViewControl.vcBtnSaveCClassesToDeviceMemory.Click += new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);


            form.controllerViewControl.vcSucRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.controllerViewControl.vcSisRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.controllerViewControl.vcNoneRadioButton.Click += new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click += new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }



        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ControllerForm form = (ControllerForm)view;

            //Form
            form.Load -= new EventHandler(actions.ControllerFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ControllerFormActions.OnFormClosing);

            form.vcResetToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnResetControllerClick);
            form.vcStartLearnModeToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnStartLearnModeClick);
            form.vcRequestUpdateToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnRequestNetworkUpdateClick);
            form.vcCreateNewPrimaryToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnCreateNewPrimaryClick);
            form.vcShiftToolStripButton.Click -= new EventHandler(actions.ControllerFormActions.OnShiftControllerClick);
            form.controllerViewControl.vcBtnLoadCClassesFromDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnLoadCClassesFromDeviceMemory);
            form.controllerViewControl.vcBtnSaveCClassesToDeviceMemory.Click -= new EventHandler(actions.ControllerFormActions.OnSaveCClassesToDeviceMemory);

            form.controllerViewControl.vcSucRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSISNetworkRoleOptionClick);
            form.controllerViewControl.vcSisRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnSUCNetworkRoleOptionClick);
            form.controllerViewControl.vcNoneRadioButton.Click -= new EventHandler(actions.ControllerFormActions.OnNoneNetworkRoleOptionClick);

            form.vcCmdAssign.Click -= new EventHandler(actions.ControllerFormActions.OnAssignNetworkRoleOptionClick);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ControllerFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
