using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Controllers;
using Zensys.ZWave.Devices;
using Zensys.ZWave;
using Zensys.ZWave.SerialPortApplication.Devices;
using System.Windows.Forms;
using Zensys.ZWave.Enums;
using Zensys.PCController.Properties;
using Zensys.ZWave.ZWaveHAL;


namespace Zensys.PCController.Actions
{
    public class SetupRouteFormActions : BaseAction
    {
        public SetupRouteFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.SetupRouteForm.vcSourceListView.DataSource = ControllerManager.DocumentModel.RoutesCollection;
            ControllerManager.SetupRouteForm.vcDestinationListView.DataSource = ControllerManager.DocumentModel.RoutesCollection;
            OnDocumentModelStateChanged();
        }
        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.SetupRouteToolStripMenuItem.Checked = false;
            ControllerManager.SetupRouteForm.Hide();
            e.Cancel = true;
        }
        #endregion

        #region DocumentModel
        public void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            OnDocumentModelStateChanged();
        }

        private delegate void OnDocumentModelStateChangedDelegate();
        private void OnDocumentModelStateChanged()
        {
            if (ControllerManager.SetupRouteForm != null && !ControllerManager.SetupRouteForm.IsDisposed)
            {
                if (ControllerManager.SetupRouteForm.InvokeRequired)
                {
                    ControllerManager.SetupRouteForm.Invoke(new OnDocumentModelStateChangedDelegate(OnDocumentModelStateChanged));
                }
                else
                {
                    ControllerManager.SetupRouteForm.vcAssignToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute != null &&
                        ControllerManager.DocumentModel.RoutesCollection.SelectedDestinationRoute != null;
                    ControllerManager.SetupRouteForm.vcDeleteToolStripButton.Enabled =
                        ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute != null &&
                        ControllerManager.DocumentModel.RoutesCollection.SelectedDestinationRoute != null;
                    ControllerManager.SetupRouteForm.vcSourceListView.Enabled =
                        ControllerManager.DocumentModel.Controller != null;
                    ControllerManager.SetupRouteForm.vcDestinationListView.Enabled =
                        ControllerManager.DocumentModel.Controller != null;
                }
            }
        }
        #endregion

        public void OnAssignButtonClick(object sender, EventArgs e)
        {
            ProcessReturnRoute(true);
        }
        public void OnDeleteButtonClick(object sender, EventArgs e)
        {
            ProcessReturnRoute(false);
        }
        private void ProcessReturnRoute(bool isAssign)
        {
            if (isAssign)
            {
                if (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute != null && ControllerManager.DocumentModel.RoutesCollection.SelectedDestinationRoute != null)
                {

                    ControllerManager.DoAction(new EventHandler(delegate
                      {
                          IController controller = ControllerManager.DocumentModel.Controller;
                          try
                          {
                              if (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.IsListening || ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.IsCommandQueueOverrided)
                              {
                                  AssignReturnRoute(controller);
                              }
                              else
                              {
                                  if ((ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Security & 0x20) != 0 ||
                                     (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Security & 0x40) != 0)
                                  {
                                      AssignReturnRoute(controller);
                                  }
                                  else
                                  {
                                      QueueAction action = new QueueAction(
                                            new AssignReturnRouteDelegate(AssignReturnRoute),
                                            new object[] { controller },
                                            Resources.MsgAssignReturnRoute, false, (byte)CommandTypes.None, "Assign Return Route", 0);
                                      ControllerManager.AddQueueCommand(ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id, action);
                                      ControllerManager.LogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Assign Return Route", ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id));
                                  }
                              }
                          }
                          catch (Exception ex)
                          {
                              throw ex;
                          }

                      }), null, Resources.MsgAssignReturnRoute, false, (byte)CommandTypes.None);

                }
            }
            else
            {
                if (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute != null)
                {

                    ControllerManager.DoAction(new EventHandler(delegate
                      {
                          IController controller = ControllerManager.DocumentModel.Controller;
                          try
                          {
                              if (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.IsListening || ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.IsCommandQueueOverrided)
                              {
                                  RemoveReturnRoute(controller);
                              }
                              else
                              {
                                  if ((ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Security & 0x20) != 0 ||
                                     (ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Security & 0x40) != 0)
                                  {
                                      RemoveReturnRoute(controller);
                                  }
                                  else
                                  {
                                      QueueAction action = new QueueAction(
                                            new RemoveReturnRouteDelegate(RemoveReturnRoute),
                                            new object[] { controller },
                                            Resources.MsgAssignReturnRoute, false, (byte)CommandTypes.None, "Remove Return Route", 0);
                                      ControllerManager.AddQueueCommand(ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id, action);
                                      ControllerManager.LogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Remove Return Route", ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id));
                                  }
                              }
                          }
                          catch (Exception ex)
                          {
                              throw ex;
                          }

                      }), null, Resources.MsgAssignReturnRoute, false, (byte)CommandTypes.None);
                }

            }

        }

        private delegate void RemoveReturnRouteDelegate(IController controller);
        private void RemoveReturnRoute(IController controller)
        {
            controller.DeleteReturnRoute(ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id);
        }

        private delegate void AssignReturnRouteDelegate(IController controller);
        private void AssignReturnRoute(IController controller)
        {
            controller.AssignReturnRoute(ControllerManager.DocumentModel.RoutesCollection.SelectedSourceRoute.Device.Id,
                ControllerManager.DocumentModel.RoutesCollection.SelectedDestinationRoute.Device.Id);
        }
    }
}