using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Controllers;
using Zensys.PCController.UI;
using Zensys.PCController.Interfaces;
using WeifenLuo.WinFormsUI.Docking;
using System.IO;
using Zensys.PCController.Properties;
using System.Windows.Forms;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using Zensys.ZWave.SerialPortApplication.Devices;
using System.Xml;
using Zensys.PCController.Layout;
using Zensys.ZWave.Logging;
using Zensys.ZWave;
using Zensys.Framework;
using System.Collections;
using System.Reflection;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.SerialPortTransport;

namespace Zensys.PCController.Actions
{
    public class MainFormActions : BaseAction
    {
        public MainFormActions(ControllerManager controller)
            : base(controller)
        {

        }

        void DocumentModel_ControllerChanged(object sender, EventArgs e)
        {
            ControllerManager.MainForm.LabelStatusText = "";
            if (ControllerManager.DocumentModel.Controller != null)
            {
                ControllerManager.MainForm.LabelHomeIdText = Tools.ToHexString(ControllerManager.DocumentModel.Controller.HomeId);
                ControllerManager.MainForm.LabelNodeIdText = Tools.ToHexString(ControllerManager.DocumentModel.Controller.Id);
            }
            else
            {
                ControllerManager.MainForm.LabelHomeIdText = "";
                ControllerManager.MainForm.LabelNodeIdText = "";
            }
        }
        #region Form
        public void OnFormLoad(object sender, EventArgs e)
        {
            Settings.Default.Reload();
            LayoutManager.OnLoad(ControllerManager, DeserializeDockContent);

            if (!string.IsNullOrEmpty(Settings.Default.LastUsedDevice))
            {

                if (!StoragePerPort.GetData(Settings.Default.CommandClassesStore, Settings.Default.LastUsedDevice, ref ControllerManager.DocumentModel.ExternalCommandClassesStorage))
                {
                    ControllerManager.DocumentModel.ExternalCommandClassesStorage = new byte[2000];
                }

                IController device = null;
                ControllerManager.DoAction(new EventHandler(delegate
                  {
                      device = ControllerManager.Actions.CommonActions.DetectDevice(Settings.Default.LastUsedDevice, Settings.Default.LastUsedDevice.StartsWith("socket:///"));
                  }), null, Resources.MsgSettingsDetectInterface, false, (byte)CommandTypes.None);
                if (device != null && IsControllerLibrary(device.Version.Library))
                {
                    ControllerManager.DocumentModel.SetUpController(device);
                    ControllerManager.Actions.CommonActions.SetUpController();
                }
            }
        }
        public void OnFormClosing(object sender, EventArgs e)
        {
            if (ControllerManager.ErttForm != null)
            {
                ControllerManager.ErttForm.Close();
            }
            if (ControllerManager.DocumentModel.Controller != null)
            {
                if (ControllerManager.DocumentModel.Controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                {
                    ControllerManager.DocumentModel.Controller.Close();
                }
            }
            if (ControllerManager.DocumentModel.ExternalCommandClassesStorage != null && Settings.Default.LastUsedDevice != null)
            {
                Settings.Default.CommandClassesStore = StoragePerPort.StoreData(Settings.Default.CommandClassesStore, Settings.Default.LastUsedDevice, ControllerManager.DocumentModel.ExternalCommandClassesStorage);
            }
            ControllerManager.Actions.CommonActions.FinalizeEntryPointHAL();
            LayoutManager.OnClose(ControllerManager);
            Settings.Default.Save();
        }


        public void OnKeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            if (e.Control == true && e.KeyCode == Keys.E)
            {
                ControllerManager.ShowView(typeof(ErttForm), true);
            }
        }

        public void OnErttClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(ErttForm), true);
        }
        public void OnTopologyMapToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(RoutingTableForm), ControllerManager.MainForm.TopologyMapToolStripMenuItem.Checked);
        }


        private IDockContent DeserializeDockContent(string stringId)
        {
            IDockContent ret = null;
            if (stringId == typeof(NodeForm).FullName)
            {
                ControllerManager.NodeForm = new NodeForm();
                ret = ControllerManager.NodeForm;
            }
            else if (stringId == typeof(ControllerForm).FullName)
            {
                ControllerManager.ControllerForm = new ControllerForm();
                ret = ControllerManager.ControllerForm;
            }
            else if (stringId == typeof(CommandClassForm).FullName)
            {
                ControllerManager.CommandClassForm = new CommandClassForm();
                ret = ControllerManager.CommandClassForm;
            }
            else if (stringId == typeof(AssociationsForm).FullName)
            {
                ControllerManager.AssociationsForm = new AssociationsForm();
                ret = ControllerManager.AssociationsForm;
            }
            else if (stringId == typeof(SetupRouteForm).FullName)
            {
                ControllerManager.SetupRouteForm = new SetupRouteForm();
                ret = ControllerManager.SetupRouteForm;
            }
            else if (stringId == typeof(LogForm).FullName)
            {
                ControllerManager.LogForm = new LogForm();
                ret = ControllerManager.LogForm;
            }
            return ret;
        }


        #endregion

        #region Help
        public void OnAboutToolStripMenuItemClick(object sender, EventArgs e)
        {
            AboutBox about = new AboutBox();
            about.ShowDialog();
        }
        public void OnIndexToolStripMenuItemClick(object sender, EventArgs e)
        {
            //IDevice reqNode = null;
            //ControllerManager.DoAction(new EventHandler(delegate
            //{
            //    reqNode = ControllerManager.DocumentModel.Controller.RequestNodeInfo(0x02);
            //}), "", false, 0x00);
            //string a = "";
        }
        public void OnSearchToolStripMenuItemClick(object sender, EventArgs e)
        {

        }
        public void OnContentsToolStripMenuItemClick(object sender, EventArgs e)
        {

        }
        #endregion

        #region Views
        public void OnAssociationsToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(AssociationsForm), ControllerManager.MainForm.AssociationsToolStripMenuItem.Checked);
        }
        public void OnCmdClassToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(CommandClassForm), ControllerManager.MainForm.CmdClassToolStripMenuItem.Checked);
        }
        public void OnControllerToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(ControllerForm), ControllerManager.MainForm.ControllerToolStripMenuItem.Checked);
        }
        public void OnNodeToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(NodeForm), ControllerManager.MainForm.NodeToolStripMenuItem.Checked);
        }
        public void OnSetupRouteToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(SetupRouteForm), ControllerManager.MainForm.SetupRouteToolStripMenuItem.Checked);
        }
        public void OnLogToolStripMenuItemClick(object sender, EventArgs e)
        {
            ControllerManager.ShowView(typeof(LogForm), ControllerManager.MainForm.LogToolStripMenuItem.Checked);
        }
        #endregion

        #region Other
        public void OnExitToolStripMenuItemClick(object sender, EventArgs e)
        {
            Application.Exit();
        }
        public void OnSettingsToolStripMenuItemClick(object sender, EventArgs e)
        {
            IController device = null;
            SettingsForm settingsForm = new SettingsForm();
            settingsForm.OnLoadInterfaces += new EventHandler(SettingsOnLoadInterfaces);
            settingsForm.OnDetectInterface += new EventHandler(SettingsOnDetectInterface);
            if (!string.IsNullOrEmpty(Settings.Default.LastUsedDevice) && Settings.Default.LastUsedDevice.StartsWith("socket:///"))
            {
                settingsForm.UriTextBox.Text = Settings.Default.LastUsedDevice;
                settingsForm.CbIsRemoteSerialApi.Checked = true;
            }
            else
            {
                settingsForm.UriTextBox.Text = "";
                settingsForm.CbIsRemoteSerialApi.Checked = false;
            }
            if (settingsForm.ShowDialog(ControllerManager.MainForm) == DialogResult.OK)
            {
                if (ControllerManager.DocumentModel.ExternalCommandClassesStorage != null && Settings.Default.LastUsedDevice != null)
                {
                    Settings.Default.CommandClassesStore = StoragePerPort.StoreData(Settings.Default.CommandClassesStore, Settings.Default.LastUsedDevice, ControllerManager.DocumentModel.ExternalCommandClassesStorage);
                }
                ControllerManager.Actions.CommonActions.FinalizeEntryPointHAL();
                if (ControllerManager.DocumentModel.Controller != null)
                {
                    ControllerManager.DocumentModel.Controller.Close();
                    ControllerManager.DocumentModel.Controller.Dispose();
                    ControllerManager.DocumentModel.Controller = null;
                }

                //if (settingsForm.SelectedDevice != null && IsControllerLibrary(settingsForm.SelectedDevice.Version.Library))
                //{
                //    Settings.Default.LastUsedDevice = settingsForm.SelectedDevice.SerialPort;
                //    if (!StoragePerPort.GetData(Settings.Default.CommandClassesStore, Settings.Default.LastUsedDevice, ref ControllerManager.DocumentModel.ExternalCommandClassesStorage))
                //    {
                //        ControllerManager.DocumentModel.ExternalCommandClassesStorage = new byte[2000];
                //    }
                //    ControllerManager.DocumentModel.SetUpController(settingsForm.SelectedDevice);
                //    ControllerManager.Actions.CommonActions.SetUpController();
                //}
                //else
                {
                    ControllerManager.DoAction(new EventHandler(delegate
                    {
                        try
                        {
                            if (ControllerManager.DocumentModel.Controller != null)
                            {
                                ControllerManager.DocumentModel.Controller.Close();
                            }
                            if (settingsForm.SelectedDeviceId == null && !String.IsNullOrEmpty(settingsForm.UriTextBox.Text) && settingsForm.UriTextBox.Text.Contains("socket:///")) //TCP interface
                            {
                                device = ControllerManager.Actions.CommonActions.DetectDevice(settingsForm.UriTextBox.Text, settingsForm.CbIsRemoteSerialApi.Checked);
                            }
                            else if (settingsForm.SelectedDeviceId != null) // COM interface
                            {
                                device = ControllerManager.Actions.CommonActions.DetectDevice(settingsForm.SelectedDeviceId, false);
                            }
                            else if (settingsForm.InterfacesListBox.SelectedItem != null && settingsForm.InterfacesListBox.SelectedItem.ToString().Contains(@"\\?\usb#vid_")) // USB interface
                            {
                                device = ControllerManager.Actions.CommonActions.DetectDevice(settingsForm.InterfacesListBox.SelectedItem.ToString(), false);
                            }

                            if (device != null)
                            {

                            }
                        }
                        catch (Exception ex)
                        {
                            throw ex;
                        }
                    }), null, Resources.MsgSettingsDetectInterface, false, (byte)CommandTypes.None);


                    if (device != null && IsControllerLibrary(device.Version.Library))
                    {
                        Settings.Default.LastUsedDevice = device.SerialPort;
                        if (!StoragePerPort.GetData(Settings.Default.CommandClassesStore, Settings.Default.LastUsedDevice, ref ControllerManager.DocumentModel.ExternalCommandClassesStorage))
                        {
                            ControllerManager.DocumentModel.ExternalCommandClassesStorage = new byte[2000];
                        }
                        ControllerManager.DocumentModel.SetUpController(device);
                        ControllerManager.Actions.CommonActions.SetUpController();
                    }
                    else if (device != null)
                    {
                        Settings.Default.LastUsedDevice = null;
                        MessageBox.Show(Resources.MsgNoControllerLibrary, Resources.CaptionZWaveController);
                    }
                    else
                    {
                        Settings.Default.LastUsedDevice = null;
                        MessageBox.Show(Resources.MsgNoControllerDevice, Resources.CaptionZWaveController);
                    }
                }
            }
        }

        public void OnSecurityTestSchemaClick(object sender, EventArgs e)
        {
            // ControllerManager.ShowView(typeof(SecurityTestSchemaForm), true);
        }

        public void OnCommandQueueStatusLabelClick(object sender, EventArgs e)
        {
            if (ControllerManager.FramesToSend.Count > 0)
            {
                ControllerManager.QueueActionsForm = new QueueActionsForm();
                ControllerManager.QueueActionsForm.TreeViewActions.Nodes.Clear();

                foreach (byte nodeId in ControllerManager.FramesToSend.Keys)
                {
                    TreeNode node = ControllerManager.QueueActionsForm.TreeViewActions.Nodes.Add("Non-listening Node: " + nodeId.ToString().PadLeft(3, '0'));
                    Queue<QueueAction> queue = ControllerManager.FramesToSend[nodeId];
                    node.Tag = queue;
                    foreach (QueueAction action in queue)
                    {
                        TreeNode childNode = node.Nodes.Add("Action: " + action.ActionName);
                        //childNode.Text += "(Method Name: " + action.ActionHandler.Method.Name + ", Parameters:";
                        //foreach (ParameterInfo p in action.ActionHandler.Method.GetParameters())
                        //{
                        //    childNode.Text += p.Name + ": " + p.DefaultValue;
                        //}
                        //childNode.Text += ")";
                        childNode.Tag = action;
                    }

                }
                ControllerManager.QueueActionsForm.ShowDialog(ControllerManager.MainForm);

            }


        }

        private void SettingsOnDetectInterface(object sender, EventArgs e)
        {
            if (sender is SettingsForm)
            {
                SettingsForm form = sender as SettingsForm;
                IController device = null;
                SortedList<string, IController> detectedControllers = new SortedList<string, IController>();
                ControllerManager.DoAction(new EventHandler(delegate
                {
                    try
                    {
                        if (ControllerManager.DocumentModel.Controller != null)
                        {
                            ControllerManager.DocumentModel.Controller.Close();
                        }
                        List<Win32PnPEntityClass> interfaces = ComputerSystemHardwareHelper.GetWin32PnPEntityClassSerialPortDevices();
                        foreach (Win32PnPEntityClass serialPortInfo in interfaces)
                        {

                            device = ControllerManager.Actions.CommonActions.DetectDevice(serialPortInfo.DeviceID, false);
                            if (device != null)
                            {
                                detectedControllers.Add(serialPortInfo.DeviceID, device);
                            }

                        }
                    }
                    catch (Exception ex)
                    {
                        throw ex;
                    }

                }), null, Resources.MsgSettingsDetectInterface, false, (byte)CommandTypes.None);
                LoadInterfaces(form, detectedControllers);
            }
        }
        private void SettingsOnLoadInterfaces(object sender, EventArgs e)
        {
            if (sender is SettingsForm)
            {
                SettingsForm form = sender as SettingsForm;
                LoadInterfaces(form, new SortedList<string, IController>());
            }
        }
        private void LoadInterfaces(SettingsForm form, SortedList<string, IController> detectedControllers)
        {
            List<Win32PnPEntityClass> interfaces = ComputerSystemHardwareHelper.GetWin32PnPEntityClassSerialPortDevices();
            form.InterfacesListBox.Items.Clear();
            form.InterfacesListBox.Enabled = true;
            form.NoCommInterfacesLabel.Text = "";
            if (interfaces != null && interfaces.Count > 0)
            {
                foreach (Win32PnPEntityClass serialPortInfo in interfaces)
                {
                    IController device = null;
                    if (detectedControllers.ContainsKey(serialPortInfo.DeviceID))
                    {
                        device = detectedControllers[serialPortInfo.DeviceID];
                    }
                    int index = form.InterfacesListBox.Items.Add(new DeviceWrapper(serialPortInfo, device));
                    if (ControllerManager.DocumentModel.Controller != null &&
                        ControllerManager.DocumentModel.Controller.SerialPort == serialPortInfo.DeviceID)
                    {
                        form.InterfacesListBox.SelectedIndex = index;
                    }

                }
            }
            else
            {
                form.InterfacesListBox.Enabled = false;
                form.NoCommInterfacesLabel.Text = Resources.MsgNoCommInterfaces;
            }
            form.InterfacesListBox.Items.AddRange(UsbPort.GetPortNames());
        }


        #endregion
    }
}