using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.InstallerTool.Interfaces;
using Zensys.ZWave.InstallerTool.Classes;

namespace Zensys.ZWave.InstallerTool.UI
{
    public partial class MainForm : Form, IView
    {
        public MainForm()
        {
            InitializeComponent();
        }

        #region IView Members

        public Form ViewContainer
        {
            get { return this; }
        }

        private DockStyle mDockStyle = DockStyle.None;
        /// <summary>
        /// Gets or sets the dock style.
        /// </summary>
        /// <value>The dock style.</value>
        public DockStyle DockStyle
        {
            get
            {
                return mDockStyle;
            }
            set
            {
                mDockStyle = value;
            }
        }


        public System.Windows.Forms.MenuStrip MainMenu
        {
            get { return mainMenu; }
        }

        public System.Windows.Forms.StatusStrip MainStatusStrip
        {
            get { return mainStatusStrip; }
        }

        public WeifenLuo.WinFormsUI.Docking.DockPanel MainDockPanel
        {
            get { return mainDockPanel; }
        }

        public System.Windows.Forms.ToolStripMenuItem NodeToolStripMenuItem
        {
            get { return nodeToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem ControllerToolStripMenuItem
        {
            get { return controllerToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem LogToolStripMenuItem
        {
            get { return logToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem SettingsToolStripMenuItem
        {
            get { return settingsToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem ExitToolStripMenuItem
        {
            get { return exitToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem IndexToolStripMenuItem
        {
            get { return indexToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem ContentsToolStripMenuItem
        {
            get { return contentsToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem SearchToolStripMenuItem
        {
            get { return searchToolStripMenuItem; }
        }

        public System.Windows.Forms.ToolStripMenuItem AboutToolStripMenuItem
        {
            get { return aboutToolStripMenuItem; }
        }
        
        public System.Windows.Forms.ToolStripStatusLabel LabelStatusText
        {
            get { return labelStatusText; }
        }
        
        public System.Windows.Forms.ToolStripMenuItem TopologyMapToolStripMenuItem
        {
            get { return topologyMapToolStripMenuItem; }
        }
        #endregion
    }
}