using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;
using Zensys.ZWave.InstallerTool.Classes;

namespace Zensys.ZWave.InstallerTool.UI
{
    /// <summary>
    /// Displays a form that contains information about application
    /// </summary>
    public partial class AboutBox : Form
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AboutBox"/> class.
        /// 
        /// Version number has been replaced with constant value.
        /// this is Workaround to provide the compatibility with SysTestDB versioning 
        /// while keep the internal version number usable for tracking the real application version. 
        /// </summary>
        public AboutBox()
        {
            InitializeComponent();

            //  Initialize the AboutBox to display the product information from the assembly information.
            //  Change assembly information settings for your application through either:
            //  - Project->Properties->Application->Assembly Information
            //  - AssemblyInfo.cs
            this.Text = String.Format("About {0}", AssemblyAttributeAccessor.AssemblyTitle);
            this.labelProductName.Text = AssemblyAttributeAccessor.AssemblyProduct;
            //this.labelVersion.Text = String.Format("Version {0} {1}", AssemblyVersion, AssemblyInfoVersion);
            this.labelVersion.Text = String.Format("Version {0}", AssemblyAttributeAccessor.AssemblyVersion);
            this.labelCopyright.Text = AssemblyAttributeAccessor.AssemblyCopyright;
            this.labelCompanyName.Text = AssemblyAttributeAccessor.AssemblyCompany;
            this.textBoxDescription.Text = AssemblyAttributeAccessor.AssemblyDescription;
        }

    }
}
