using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using Zensys.ZWave.Devices;
using Zensys.ZWave.InstallerTool.Properties;

namespace Zensys.ZWave.InstallerTool.Models
{
    public class TopologyMapItem
    {
        protected XmlDataManager mXmlDataManager;
        public TopologyMapItem(IDeviceInfo device, byte[] deviceRoutingInfo, XmlDataManager xmlDataManager)
        {
            mDevice = device;
            mDeviceRoutingInfo = deviceRoutingInfo;
            mXmlDataManager = xmlDataManager;
        }

        private byte[] mDeviceRoutingInfo;

        public byte[] DeviceRoutingInfo
        {
            get { return mDeviceRoutingInfo; }
            set { mDeviceRoutingInfo = value; }
        }

        private IDeviceInfo mDevice;

        public IDeviceInfo Device
        {
            get { return mDevice; }
            set { mDevice = value; }
        }

        public Color GetColorByDeviceType()
        {
            if (this.Device != null)
            {
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_AV_CONTROL_POINT").KeyId == this.Device.Generic) return Settings.Default.GenericTypeAvControlPoint_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_ENTRY_CONTROL").KeyId == this.Device.Generic) return Settings.Default.GenericTypeEntryControl_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_GENERIC_CONTROLLER").KeyId == this.Device.Generic) return Settings.Default.GenericTypeGenericController_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_METER").KeyId == this.Device.Generic) return Settings.Default.GenericTypeMeter_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_METER_PULSE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeMeterPulse_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_NON_INTEROPERABLE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeNonInteroperable_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_REPEATER_SLAVE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeRepeaterSlave_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SEMI_INTEROPERABLE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSemiInteroperable_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SENSOR_ALARM").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSensorAlarm_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SENSOR_BINARY").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSensorBinary_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SENSOR_MULTILEVEL").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSensorMultilevel_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_STATIC_CONTROLLER").KeyId == this.Device.Generic) return Settings.Default.GenericTypeStaticController_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SWITCH_BINARY").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSwitchBinary_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SWITCH_MULTILEVEL").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSwitchMultilevel_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SWITCH_REMOTE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSwitchRemote_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_SWITCH_TOGGLE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeSwitchToggle_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_THERMOSTAT").KeyId == this.Device.Generic) return Settings.Default.GenericTypeThermostat_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_WINDOW_COVERING").KeyId == this.Device.Generic) return Settings.Default.GenericTypeWindowCovering_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_ZIP_GATEWAY").KeyId == this.Device.Generic) return Settings.Default.GenericTypeZipGateway_NodeColor;
                if (mXmlDataManager.FindGenericDevice("GENERIC_TYPE_ZIP_NODE").KeyId == this.Device.Generic) return Settings.Default.GenericTypeZipNode_NodeColor;
                return Settings.Default.Unknown_NodeColor;

            }
            return Settings.Default.Unknown_NodeColor;
        }

    }
}
