using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.InstallerTool.Models
{
    /// <summary>
    /// 
    /// </summary>
    public class DeviceItem
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceItem"/> class.
        /// </summary>
        /// <param name="device">The device.</param>
        /// <param name="isFailed">if set to <c>true</c> [is failed].</param>
        public DeviceItem(IDevice device, bool isFailed)
        {
            mDevice = device;
            mIsFailed = isFailed;
        }

        private IDevice mDevice;
        /// <summary>
        /// Gets or sets the device.
        /// </summary>
        /// <value>The device.</value>
        public IDevice Device
        {
            get { return mDevice; }
            set { mDevice = value; }
        }

        private bool mIsFailed;
        /// <summary>
        /// Gets or sets a value indicating whether this instance is failed.
        /// </summary>
        /// <value><c>true</c> if this instance is failed; otherwise, <c>false</c>.</value>
        public bool IsFailed
        {
            get { return mIsFailed; }
            set { mIsFailed = value; }
        }
    }
}
