using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using Zensys.Framework;
using Zensys.ZWave.Logging;
using Zensys.ZWave.InstallerTool.Models;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.InstallerTool.Controls
{
    public class ListDevicesView : ListView
    {
        private DevicesCollection dataSource;
        private void BuildList()
        {
            lock (this)
            {
                BeginUpdate();
                this.Items.Clear();
                foreach (DeviceItem device in dataSource.Devices)
                {
                    ListViewItem item = new ListViewItem(new string[] { device.Device.Id.ToString(), device.Device.Type.ToString() });
                    item.Tag = device;
                    if (device.IsFailed)
                    {
                        item.ForeColor = Color.Red;
                    }
                    Items.Add(item);
                }
                EndUpdate();
            }
        }

        protected override void OnSelectedIndexChanged(EventArgs e)
        {
            base.OnSelectedIndexChanged(e);
            if (SelectedItems != null && SelectedItems.Count > 0)
            {
                dataSource.SelectedDevice = GetRow(SelectedItems[0]);
            }
            else
            {
                dataSource.SelectedDevice = null;
            }
        }

        public DeviceItem GetRow(ListViewItem listViewItem)
        {
            return listViewItem.Tag as DeviceItem;
        }
        
        public void SelectNode(DeviceItem deviceItem)
        {
            if (deviceItem != null)
            {
                foreach (ListViewItem listViewItem in Items)
                {
                    if (GetRow(listViewItem).Device.Id == deviceItem.Device.Id)
                    {
                        if (SelectedItems.Count == 0 || listViewItem != SelectedItems[0])
                        {
                            listViewItem.Selected = true;
                            break;
                        }
                    }
                }
            }
            else
            {
                foreach (ListViewItem listViewItem in Items)
                {
                    listViewItem.Selected = false;
                }
            }
        }
      
        [Category("Data")]
        public DevicesCollection DataSource
        {
            get
            {
                return dataSource;
            }
            set
            {
                if (value != null)
                {
                    dataSource = value;
                    BuildList();
                    dataSource.DeviceCollectionChanged += new EventHandler<EventArgs>(dataSource_DeviceCollectionChanged);
                    dataSource.SelectedDeviceChanged += new EventHandler<EventArgs>(dataSource_SelectedDeviceChanged);
                }
            }
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
            if (dataSource != null)
            {
                dataSource.DeviceCollectionChanged -= new EventHandler<EventArgs>(dataSource_DeviceCollectionChanged);
                dataSource.SelectedDeviceChanged -= new EventHandler<EventArgs>(dataSource_SelectedDeviceChanged);
            }
        }

        void dataSource_SelectedDeviceChanged(object sender, EventArgs e)
        {
            ReSelectNode(dataSource.SelectedDevice);
        }

        void dataSource_DeviceCollectionChanged(object sender, EventArgs e)
        {
            ReBuildList();
        }

        private delegate void ReBuildListDelegate();
        private void ReBuildList()
        {
            if (InvokeRequired)
            {
                Invoke(new ReBuildListDelegate(ReBuildList));
            }
            else
            {
                BuildList();
            }
        }

        private delegate void ReSelectNodeDelegate(DeviceItem deviceItem);
        private void ReSelectNode(DeviceItem deviceItem)
        {
            if (InvokeRequired)
            {
                Invoke(new ReSelectNodeDelegate(ReSelectNode), deviceItem);
            }
            else
            {
                SelectNode(deviceItem);
            }
        }

    }
}
