using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;
using System.Windows.Forms;
using Zensys.ZWave.InstallerTool.Interfaces;

namespace Zensys.ZWave.InstallerTool.Classes
{
    /// <summary>
    /// DockableView class. Base class for dockable forms.
    /// </summary>
    public class DockableView : DockContent, IView
    {
        #region IView Members
        /// <summary>
        /// Gets or sets the form.
        /// </summary>
        /// <value>The form.</value>
        public Form ViewContainer
        {
            get { return this; }
        }
        private DockStyle mDockStyle = DockStyle.None;
        /// <summary>
        /// Gets or sets the dock style.
        /// </summary>
        /// <value>The dock style.</value>
        public DockStyle DockStyle
        {
            get
            {
                return mDockStyle;
            }
            set
            {
                mDockStyle = value;
            }
        }
        #endregion

        /// <summary>
        /// Overrides OnLayout method.
        /// </summary>
        /// <param name="levent">Layout event arguments.</param>
        protected override void OnLayout(LayoutEventArgs levent)
        {
            base.OnLayout(levent);
            if (levent.AffectedControl is DockableView)
            {
                switch (this.DockState)
                {
                    case (DockState.DockLeft): { this.DockStyle = DockStyle.Left; } break;
                }
            }
        }
    }
}
