using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.InstallerTool.Classes;
using Zensys.ZWave.InstallerTool.Controllers;
using Zensys.ZWave.Enums;
using System.Windows.Forms;
using Zensys.ZWave.InstallerTool.Properties;
using Zensys.ZWave.InstallerTool.Models;
using Zensys.ZWave.Events;
using System.Threading;
using Zensys.ZWave.ZWaveHAL;
using Zensys.ZWave.Application;
using Zensys.Framework;

namespace Zensys.ZWave.InstallerTool.Actions
{
    public class CommonActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CommonActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public CommonActions(ControllerManager controller)
            : base(controller)
        {
        }

        #region Changing Connected Controller Device routine

        private void FillDataSources()
        {
            ControllerManager.DocumentModel.Devices.Clear();
            ControllerManager.DocumentModel.TopologyMapItemCollection.BeginUpdate();
            ControllerManager.DocumentModel.TopologyMapItemCollection.Clear();
            foreach (IDeviceInfo device in ControllerManager.DocumentModel.Controller.IncludedNodes)
            {
                GenericDevice gd = ControllerManager.XmlDataManager.FindGenericDevice(device.Generic);
                if (gd != null)
                {
                    device.Type = (String.IsNullOrEmpty(gd.Text)) ? gd.Name : gd.Text;
                }
                else
                {
                    device.Type = "Generic Device:" + Tools.ToHexString(device.Generic);
                }
                ControllerManager.DocumentModel.Devices.Add(device);
                byte[] routingInfo = null;
                ControllerManager.DoAction(new EventHandler(delegate
                    {
                        try
                        {
                            routingInfo = ControllerManager.DocumentModel.Controller.GetRoutingInfo(device.Id, 0, 0);
                        }
                        catch (Exception ex)
                        {
                            ControllerManager.WriteException(ex);
                            throw ex;
                        }

                    }), null, Resources.MsgLoadingNodes, false, (byte)CommandTypes.None);
                ControllerManager.DocumentModel.TopologyMapItemCollection.Add(new TopologyMapItem(device, routingInfo, ControllerManager.XmlDataManager));
            }
            ControllerManager.DocumentModel.TopologyMapItemCollection.EndUpdate();
        }
        public static bool IsControllerLibrary(Libraries library)
        {
            return library == Libraries.ControllerPortableLib ||
                library == Libraries.InstallerLib;
        }
        private bool isStartUp = true;
        public void SetUpController()
        {
            bool exit = false;
            ControllerManager.DoAction(new EventHandler(delegate
            {
                try
                {
                    if (ControllerManager.DocumentModel.Controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                    {
                        ControllerManager.DocumentModel.Controller.Open(ControllerManager.DocumentModel.Controller.SerialPort);
                    }
                    ControllerManager.DocumentModel.Controller.CommandClassesStore.Load();
                    ControllerManager.DocumentModel.Controller.GetNodes();
                    ControllerManager.DocumentModel.Controller.GetCapabilities();
                    ControllerManager.DocumentModel.Controller.GetControllerCapabilities();
                    ControllerManager.DocumentModel.Controller.Memory.GetId();
                    ControllerManager.DocumentModel.Controller.GetSUCNodeID();
                }
                catch (Exception ex)
                {
                    throw ex;
                }

            }), null, Resources.MsgLoadingNodes, false, (byte)CommandTypes.None);
            if ((ControllerManager.DocumentModel.Controller.NetworkRole & ControllerRoles.SUC) == 0)
            {
                if (ControllerManager.DocumentModel.Controller.IncludedNodes != null)
                {
                    if (ControllerManager.DocumentModel.Controller.IncludedNodes.Count < 2)
                    {
                        if (isStartUp)
                        {
                            //ControllerManager.Actions.ControllerFormActions.EnableSucSis(ControllerRoles.SIS);
                        }
                    }
                }
            }
            if (isStartUp)
            {
                isStartUp = false;
            }
            InitializeEntryPointHAL();
            FillDataSources(); 
            if (exit)
            {
                System.Windows.Forms.Application.Exit();
            }
        }
        private void InitializeEntryPointHAL()
        {
            ControllerManager.DoAction(new EventHandler(delegate
            {
                try
                {
                    BaseEntryPointHAL ep = CustomLoader.GetEntryPoint();
                    if (ep != null)
                    {
                        ep.Initialize(ControllerManager.DocumentModel.Controller, Settings.Default.LastUsedDevice, ControllerManager.LogManager, ControllerManager.ExceptionManager, ControllerManager.XmlDataManager);
                    }
                }
                catch (Exception ex)
                {
                    throw ex;
                }

            }), null, Resources.MsgLoadingNodes, false, (byte)CommandTypes.None);
        }

        public void FinalizeEntryPointHAL()
        {
            ControllerManager.DoAction(new EventHandler(delegate
            {
                try
                {
                    BaseEntryPointHAL ep = CustomLoader.GetEntryPoint();
                    if (ep != null)
                    {
                        ep.Finalize(ControllerManager.DocumentModel.Controller);
                    }
                }
                catch (Exception ex)
                {
                    throw ex;
                }

            }), null, Resources.MsgLoadingNodes, false, (byte)CommandTypes.None);
        }
        #endregion

        #region Controller

        public IInstallerController DetectDevice(string deviceId)
        {
            bool isError = false;
            IInstallerController device = null;
            device = ControllerManager.ZWaveManager.ApplicationLayer.CreateInstallerController();
            try
            {

                device.Open(deviceId);
                device.GetVersion();
                if (device != null && IsControllerLibrary(device.Version.Library))
                {
                    //device.GetCapabilities();
                    //device.GetControllerCapabilities();
                    //device.CommandClassesStore.Load();
                    //device.GetNodes();
                    //device.Memory.GetId();
                    //device.GetSUCNodeID();
                }
            }
            catch (Exception)
            {
                isError = true;
            }
            finally
            {
                if (device != null)
                {
                    device.Close();
                }
            }
            return isError ? null : device;
        }


        public void ControllerApplicationCommandHandlerEvent(DeviceAppCommandHandlerEventArgs args)
        {
            if (args.SourceNodeId != 0)
            {
                CommandClassValue[] values = null;
                List<byte> payload = new List<byte>();
                payload.Add(args.CommandClassKey);
                payload.Add(args.CommandKey);
                if (args.CommandBuffer != null && args.CommandBuffer.Length > 0)
                {
                    payload.AddRange(args.CommandBuffer);
                }
                ControllerManager.XmlDataManager.ParseApplicationObject(payload.ToArray(), out values);
                ProcessACH(args.SourceNodeId, args.IsBroadcast, values);
            }
        }

        private void ProcessACH(byte sourceNodeId, bool isBroadcast, CommandClassValue[] values)
        {
            if (ControllerManager.Actions.NodeFormActions.ActionsHAL != null)
                ControllerManager.Actions.NodeFormActions.ActionsHAL.ProcessApplicationCommandHandler(
                    ControllerManager.DocumentModel.Controller,
                    sourceNodeId,
                    isBroadcast,
                    values);
        }

        #endregion
    }
}
