using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Zensys.Framework.UI.Controls
{
    public class ThreadSafeLabel : Label
    {
        public delegate void SetTextDelegate(string value);
        public override string Text
        {
            get
            {
                return base.Text;
            }
            set
            {
                lock (this)
                {
                    SetText(value);
                }
            }
        }
        private void SetText(string value)
        {
            if (InvokeRequired)
            {
                Invoke(new SetTextDelegate(SetText), value);
            }
            else
            {
                base.Text = value;
            }
        }
    }
}
