using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Zensys.Framework.UI.Controls
{
    public class DataGridViewBitImageColumn : DataGridViewColumn
    {
        public DataGridViewBitImageColumn()
            : base(new DataGridViewBitImageCell())
        {
            images = new ImageList();
        }

        private ImageList images;
        public ImageList Images
        {
            get { return this.images; }
            set { this.images = value; }
        }

        private int mTrueImageIndex = -1;
        public int TrueImageIndex
        {
            get { return mTrueImageIndex; }
            set { mTrueImageIndex = value; }
        }

        private int mFalseImageIndex = -1;
        public int FalseImageIndex
        {
            get { return mFalseImageIndex; }
            set { mFalseImageIndex = value; }
        }

        public override object Clone()
        {
            DataGridViewBitImageColumn newCol = (DataGridViewBitImageColumn)base.Clone();
            newCol.images = this.images;
            newCol.TrueImageIndex = this.TrueImageIndex;
            newCol.FalseImageIndex = this.FalseImageIndex;
            return newCol;
        }
    }
}
