using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Devices;

namespace Zensys.Framework.UI.Views
{
    public partial class NodeGridViewControl : UserControl
    {
        public NodeGridViewControl()
        {
            InitializeComponent();
            mImages = new ImageList();
            mImages.TransparentColor = Color.Magenta;
            mImages.Images.AddRange(new Image[] { Properties.Resources.Listening, Properties.Resources.VSProject_xsl,
            Properties.Resources.VSObject_Properties, Properties.Resources.VSObject_Assembly, Properties.Resources.Webcontrol_Hiddenfield
            });
        }

        private ImageList mImages;
        public ImageList Images
        {
            get { return mImages; }
            set { mImages = value; }
        }

        public void MarkFailedNode(byte nodeId)
        {
            foreach (DataGridViewRow row in nodesGridView.Rows)
            {
                if (row.DataBoundItem is IDeviceInfo)
                {
                    IDeviceInfo device = (IDeviceInfo)row.DataBoundItem;
                    if (device.Id == nodeId)
                    {
                        row.DefaultCellStyle.ForeColor = Color.Red;
                    }
                }
            }
        }

        public void UnMarkFailedNode(byte nodeId)
        {
            foreach (DataGridViewRow row in nodesGridView.Rows)
            {
                if (row.DataBoundItem is IDeviceInfo)
                {
                    IDeviceInfo device = (IDeviceInfo)row.DataBoundItem;
                    if (device.Id == nodeId)
                    {
                        row.DefaultCellStyle.ForeColor = Color.Black;
                    }
                }
            }
        }
    }
}
