using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Zensys.Framework.UI.Controls;
using System.Drawing.Design;
using System.Threading;

namespace Zensys.Framework.UI.Views
{
    public partial class LogGridViewControl : UserControl
    {
        public event EventHandler FilterClick;
        public LogGridViewControl()
        {
            InitializeComponent();
            ImageList.TransparentColor = Color.Magenta;
            ImageList.Images.AddRange(new Image[] { Properties.Resources.Input, Properties.Resources.Output, Properties.Resources.Help, Properties.Resources.Information });
            mDataTable = new DataTable();
            LogBindingSource.DataSource = DataTable;
        }

        private DataTable mDataTable;
        public DataTable DataTable
        {
            get { return mDataTable; }
            set { mDataTable = value; }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            if (logGridView.Rows.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewClear, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                //logGridView.Rows.Clear();
                if (LogBindingSource != null)
                    ((DataTable)LogBindingSource.DataSource).Clear();
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (logGridView.SelectedRows != null && logGridView.SelectedRows.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewRemoveSelected, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                foreach (DataGridViewRow item in logGridView.SelectedRows)
                {
                    logGridView.Rows.Remove(item);
                    if (LogBindingSource != null)
                    {
                        LogBindingSource.Remove(item.DataBoundItem);
                    }
                }
            }
        }


        /// <summary>
        /// Registers the menu.
        /// </summary>
        /// <param name="mainMenu">The main menu.</param>
        public void RegisterMenu(MenuStrip mainMenu)
        {
            ToolStripMenuItem logMenu = null;
            foreach (ToolStripItem var in mainMenu.Items)
            {
                if (var is ToolStripMenuItem)
                {
                    if (var.Text == Properties.Resources.menuLogView)
                    {
                        logMenu = var as ToolStripMenuItem;
                        break;
                    }
                }
            }
            if (logMenu == null)
            {
                logMenu = new ToolStripMenuItem();
                logMenu.Text = Properties.Resources.menuLogView;
                mainMenu.Items.Add(logMenu);
            }
            logMenu.DropDownItems.Clear();
            ToolStripItem removeMenuItem = CreateAsToolStripButton(btnRemove);
            removeMenuItem.Click += btnRemove_Click;
            ToolStripItem clearMenuItem = CreateAsToolStripButton(btnClear);
            clearMenuItem.Click += btnClear_Click;
            logMenu.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] { removeMenuItem, clearMenuItem });
        }

        private ToolStripItem CreateAsToolStripButton(ToolStripButton btn)
        {
            ToolStripItem ret = new ToolStripMenuItem();
            ret.Text = btn.Text;
            ret.ToolTipText = btn.ToolTipText;
            ret.Image = btn.Image;
            return ret;
        }

        public DataGridView LogGridView
        {
            get { return logGridView; }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            if (FilterClick != null)
            {
                FilterClick(this, EventArgs.Empty);
            }
            if (string.IsNullOrEmpty(LogBindingSource.Filter))
            {
                LogBindingSource.Filter = "IsRequest = true";
            }
            else
            {
                LogBindingSource.RemoveFilter();
            }

        }

        private void btnResetSort_Click(object sender, EventArgs e)
        {
            LogBindingSource.RemoveSort();
        }

        private void btnCopy_Click(object sender, EventArgs e)
        {
            if (logGridView.SelectedRows != null)
            {
                //if (logGridView.SelectedRows.Count > 10000)
                //    if (MessageBox.Show(Properties.Resources.msgLogViewTooManyItems, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                //        return;

                if (logGridView.SelectedRows.Count > 0)
                {
                    StringBuilder sb = new StringBuilder();
                    SortedDictionary<int, DataGridViewRow> rows = new SortedDictionary<int, DataGridViewRow>();
                    foreach (DataGridViewRow row in logGridView.SelectedRows)
                    {
                        rows.Add(row.Index, row);
                    }
                    foreach (KeyValuePair<int, DataGridViewRow> item in rows)
                    {
                        if (item.Value.DataBoundItem != null && item.Value.DataBoundItem is DataRowView)
                        {
                            DataRowView itemView = (System.Data.DataRowView)item.Value.DataBoundItem;
                            if (itemView.Row != null && itemView.Row.ItemArray != null)
                            {
                                if ((bool)itemView.Row.ItemArray[0] == true)
                                {
                                    sb.Append("HOST->ZW");
                                }
                                else
                                {
                                    sb.Append("ZW->HOST");
                                }
                                sb.Append("\t");
                                if ((bool)itemView.Row.ItemArray[1] == true)
                                {
                                    sb.Append("REQ");
                                }
                                else
                                {
                                    sb.Append("RES");
                                }
                                sb.Append("\t");
                                sb.Append((DateTime)itemView.Row.ItemArray[2]);
                                sb.Append("\t");
                                if (itemView.Row.ItemArray[3] is string)
                                    sb.Append(((string)itemView.Row.ItemArray[3]).Replace("\0", ""));
                                sb.Append("\t");
                                if (itemView.Row.ItemArray[4] is string)
                                    sb.Append(((string)itemView.Row.ItemArray[4]).Replace("\0", ""));
                                sb.Append("\t");
                                if (itemView.Row.ItemArray.Length > 5 && !(itemView.Row.ItemArray[5] is DBNull))
                                {
                                    if (itemView.Row.ItemArray[5] is byte[])
                                    {
                                        sb.Append(Tools.ToHexString(itemView.Row.ItemArray[5] as byte[], " "));
                                    }
                                    else
                                    {
                                        sb.Append("");
                                    }
                                }
                                else
                                {
                                    sb.Append("");
                                }

                                /*
                                 -		itemView.Row.ItemArray	{Dimensions:[0x00000006]}	object[]
                                        [0x00000000]	true	object {bool}
                                        [0x00000001]	true	object {bool}
                                +		[0x00000002]	{7/3/2012 12:05:42 PM}	object {System.DateTime}
                                        [0x00000003]	"CmdZWaveGetVersion"	object {string}
                                        [0x00000004]	""	object {string}
                                +		[0x00000005]	{}	object {System.DBNull}

                                 */
                            }
                        }
                        sb.Append(Environment.NewLine);
                    }

                    //foreach (ListViewItem item in logView.SelectedItems)
                    //{
                    //    if (item.ImageIndex == InputImageIndex)
                    //        sb.Append("IN");
                    //    else
                    //        sb.Append("OUT");
                    //    for (int i = 1; i < ItemColumns.Count; i++)
                    //    {
                    //        sb.Append('\t');
                    //        sb.Append(item.SubItems.Count > i && item.SubItems[i] != null ? item.SubItems[i].Text : "N/A");
                    //    }
                    //    sb.Append(Environment.NewLine);
                    //}
                    Clipboard.SetText(sb.ToString());
                }
            }
        }
    }
}
