using System;
using System.Collections.Generic;
using System.Text;
using Zensys.Framework;

namespace Zensys.ZWave.ZWaveHAL
{
    public class LogManager
    {
        public delegate void WriteMessageCallback(string message);
        WriteMessageCallback mLogMessageCallback;
        WriteMessageCallback mFailOperationMessageCallback;
        public LogManager(WriteMessageCallback logMessageCallback, WriteMessageCallback failOperationMessageCallback)
        {
            mLogMessageCallback = logMessageCallback;
            mFailOperationMessageCallback = failOperationMessageCallback;
        }
        public void LogMessage(string message)
        {
            if (mLogMessageCallback != null)
            {
                mLogMessageCallback(string.Format("{0}: {1}", Tools.CurrentDateTime.ToString("hh:mm:ss.fff"), message));
            }
        }

        public void LogOperationFailure(string message)
        {
            if (mLogMessageCallback != null)
            {
                mFailOperationMessageCallback(string.Format("{0}: {1}", Tools.CurrentDateTime.ToString("hh:mm:ss.fff"), message));
            }
        }
    }
}
