using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.ZWaveHAL.Actions;
using System.Reflection;
using System.IO;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.ZWaveHAL
{
    public static class CustomLoader
    {
        private static Assembly mCustomHalAssembly = null;
        private static bool mIsCustomHalAssemblyLoaded = false;
        private static BaseEntryPointHAL mEntryPointHAL = null;

        private static NodesViewActions mNodesViewActions = null;
        private static ControllerViewActions mControllerViewActions = null;
        private static CommandClassViewActions mCommandClassViewActions = null;
        private static AssociationsViewActions mAssociationsViewActions = null;
       
        public static NodesViewActions CreateNodesViewActionsInstance()
        {
            if (mNodesViewActions == null)
            {
                GetEntryPoint();
                if (mCustomHalAssembly != null)
                {
                    Type[] types = mCustomHalAssembly.GetTypes();
                    foreach (Type type in types)
                    {
                        if (type.IsSubclassOf(typeof(NodesViewActions)))
                        {
                            mNodesViewActions = (NodesViewActions)Activator.CreateInstance(type, mEntryPointHAL);
                        }
                    }
                }
                if (mNodesViewActions == null)
                {
                    mNodesViewActions = new NodesViewActions(new BaseEntryPointHAL());
                }
            }
            return mNodesViewActions;
        }

        public static ControllerViewActions CreateControllerViewActionsInstance()
        {
            if (mControllerViewActions == null)
            {
                GetEntryPoint();
                if (mCustomHalAssembly != null)
                {
                    Type[] types = mCustomHalAssembly.GetTypes();
                    foreach (Type type in types)
                    {
                        if (type.IsSubclassOf(typeof(ControllerViewActions)))
                        {
                            mControllerViewActions = (ControllerViewActions)Activator.CreateInstance(type, mEntryPointHAL);
                        }
                    }
                }
                if (mControllerViewActions == null)
                {
                    mControllerViewActions = new ControllerViewActions(new BaseEntryPointHAL());
                }
            }
            return mControllerViewActions;
        }

        public static CommandClassViewActions CreateCommandClassViewActionsInstance()
        {
            if (mCommandClassViewActions == null)
            {
                GetEntryPoint();
                if (mCustomHalAssembly != null)
                {
                    Type[] types = mCustomHalAssembly.GetTypes();
                    foreach (Type type in types)
                    {
                        if (type.IsSubclassOf(typeof(CommandClassViewActions)))
                        {
                            mCommandClassViewActions = (CommandClassViewActions)Activator.CreateInstance(type, mEntryPointHAL);
                        }
                    }
                }
                if (mCommandClassViewActions == null)
                {
                    mCommandClassViewActions = new CommandClassViewActions(new BaseEntryPointHAL());
                }
            }
            return mCommandClassViewActions;
        }

        public static AssociationsViewActions CreateAssociationsViewActionsInstance()
        {
            if (mAssociationsViewActions == null)
            {
                GetEntryPoint();
                if (mCustomHalAssembly != null)
                {
                    Type[] types = mCustomHalAssembly.GetTypes();
                    foreach (Type type in types)
                    {
                        if (type.IsSubclassOf(typeof(AssociationsViewActions)))
                        {
                            mAssociationsViewActions = (AssociationsViewActions)Activator.CreateInstance(type, mEntryPointHAL);
                        }
                    }
                }
                if (mAssociationsViewActions == null)
                {
                    mAssociationsViewActions = new AssociationsViewActions(new BaseEntryPointHAL());
                }
            }
            return mAssociationsViewActions;
        }

        public static BaseEntryPointHAL GetEntryPoint()
        {
            if (!mIsCustomHalAssemblyLoaded)
            {
                string[] customHalFileNames = Directory.GetFiles(Environment.CurrentDirectory, "*CustomHAL.dll");
                if (customHalFileNames != null && customHalFileNames.Length > 0)
                {
                    if (customHalFileNames.Length > 1)
                    {
                        throw new ApplicationException("too many Custom HAL found");
                    }
                    else
                    {
                        mCustomHalAssembly = Assembly.LoadFrom(customHalFileNames[0]);
                        if (mCustomHalAssembly != null)
                        {
                            Type[] types = mCustomHalAssembly.GetTypes();
                            foreach (Type type in types)
                            {
                                if (type.IsSubclassOf(typeof(BaseEntryPointHAL)))
                                {
                                    mEntryPointHAL = (BaseEntryPointHAL)Activator.CreateInstance(type);
                                }
                            }
                            mIsCustomHalAssemblyLoaded = true;
                        }
                    }
                }
                else
                {
                    mEntryPointHAL = new BaseEntryPointHAL();
                }
            }
            return mEntryPointHAL;
        }
    }
}
