using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Logging;

namespace Zensys.ZWave.ZWaveHAL
{
    public class AssociativeGroup : IComparable
    {
        public AssociativeGroup(BindingContext context)
        {
            mDeviceIds = new ThreadedBindingList<byte>();
            if (context != null)
            {
                mDeviceIdsCurrencyManager = (CurrencyManager)context[mDeviceIds];
            }
        }

        private byte mGroupId;
        public byte GroupId
        {
            get { return mGroupId; }
            set { mGroupId = value; }
        }


        #region Devices (nodes)
        private ThreadedBindingList<byte> mDeviceIds;
        public ThreadedBindingList<byte> DeviceIds
        {
            get { return mDeviceIds; }
            set { mDeviceIds = value; }
        }

        private CurrencyManager mDeviceIdsCurrencyManager;
        public CurrencyManager DeviceIdsCurrencyManager
        {
            get { return mDeviceIdsCurrencyManager; }
        }

        public byte CurrentDeviceId
        {
            get
            {
                if (mDeviceIdsCurrencyManager.Position != -1)
                {
                    return (byte)mDeviceIdsCurrencyManager.Current;
                }
                else
                {
                    return 0;
                }
            }
        }
        #endregion

        #region IComparable Members

        /// <summary>
        /// Compares the current instance with another object of the same type.
        /// </summary>
        /// <param name="obj">An object to compare with this instance.</param>
        /// <returns>
        /// A 32-bit signed integer that indicates the relative order of the objects being compared. The return value has these meanings: Value Meaning Less than zero This instance is less than <paramref name="obj"/>. Zero This instance is equal to <paramref name="obj"/>. Greater than zero This instance is greater than <paramref name="obj"/>.
        /// </returns>
        /// <exception cref="T:System.ArgumentException">
        /// 	<paramref name="obj"/> is not the same type as this instance. </exception>
        public int CompareTo(object obj)
        {
            AssociativeGroup aobj = (AssociativeGroup)obj;
            return GroupId.CompareTo(aobj.GroupId);
        }

        #endregion
    }
}
