using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Events;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL.Actions
{
    public delegate TResult FunctionCaller<TResult, T0>(T0 p0);
    public delegate TResult FunctionCaller<TResult, T0, T1>(T0 p0, T1 p1);
    public delegate TResult FunctionCaller<TResult, T0, T1, T2>(T0 p0, T1 p1, T2 p2);
    public delegate TResult FunctionCaller<TResult, T0, T1, T2, T3>(T0 p0, T1 p1, T2 p2, T3 p3);
    public delegate TResult FunctionCaller<TResult, T0, T1, T2, T3, T4>(T0 p0, T1 p1, T2 p2, T3 p3, T4 p4);

    public delegate void ProcedureCaller();
    public delegate void ProcedureCaller<T0>(T0 p0);
    public delegate void ProcedureCaller<T0, T1>(T0 p0, T1 p1);
    public delegate void ProcedureCaller<T0, T1, T2>(T0 p0, T1 p1, T2 p2);
    public delegate void ProcedureCaller<T0, T1, T2, T3>(T0 p0, T1 p1, T2 p2, T3 p3);
    public delegate void ProcedureCaller<T0, T1, T2, T3, T4>(T0 p0, T1 p1, T2 p2, T3 p3, T4 p4);
    public delegate void ProcedureCaller<T0, T1, T2, T3, T4, T5>(T0 p0, T1 p1, T2 p2, T3 p3, T4 p4, T5 p5);
    public delegate void ProcedureCaller<T0, T1, T2, T3, T4, T5, T6>(T0 p0, T1 p1, T2 p2, T3 p3, T4 p4, T5 p5, T6 p6);
    
    public class ActionsHAL
    {
        protected LogManager mLogManager;
        protected XmlDataManager mXmlDataManager;
        protected ExceptionManager mExceptionManager;

        protected BaseEntryPointHAL mEntryPointHAL;

        public ActionsHAL(BaseEntryPointHAL entryPointHAL)
        {
            mEntryPointHAL = entryPointHAL;
        }

        /// <summary>
        /// Initializes the specified log manager.
        /// </summary>
        /// <param name="logManager">The log manager.</param>
        /// <param name="exceptionManager">The exception manager.</param>
        public void Initialize(LogManager logManager, ExceptionManager exceptionManager, XmlDataManager xmlDataManager)
        {
            mLogManager = logManager;
            mExceptionManager = exceptionManager;
            mXmlDataManager = xmlDataManager;
        }

        public virtual void ProcessApplicationCommandHandler(IController controller, byte sourceNodeId, bool isBroadCast, CommandClassValue[] commandClassValues)
        { 
        }
    }
}
