using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Events
{
    /// <summary>
    /// Provides data for <see cref="Zensys.ZWave.Devices.IDevice.ApplicationCommandHandlerEvent"/> event.
    /// </summary>
    public class DeviceAppCommandHandlerEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceAppCommandHandlerEventArgs"/> class.
        /// </summary>
        /// <param name="frameBuffer">The frame buffer.</param>
        /// <param name="sourceNodeId">The source node id.</param>
        /// <param name="commandClassKey">The command class key.</param>
        /// <param name="commandKey">The command key.</param>
        public DeviceAppCommandHandlerEventArgs(byte[] commandBuffer, byte sourceNodeId, byte commandClassKey, byte commandKey, bool isBroadcast)
        {
            CommandBuffer = commandBuffer;
            SourceNodeId = sourceNodeId;
            CommandClassKey = commandClassKey;
            CommandKey = commandKey;
            IsBroadcast = isBroadcast;
        }
        /// <summary>
        /// 
        /// </summary>
        public bool IsBroadcast;
        /// <summary>
        /// 
        /// </summary>
        public byte[] CommandBuffer;
        /// <summary>
        /// 
        /// </summary>
        public byte SourceNodeId;
        /// <summary>
        /// 
        /// </summary>
        public byte CommandClassKey;
        /// <summary>
        /// 
        /// </summary>
        public byte CommandKey;
    }
}
