using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Events
{
    /// <summary>
    /// Provides data for <see cref="ITransportLayer.DataReceived"/> event.
    /// </summary>
    public class DataReceivedEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DataReceivedEventArgs"/> class.
        /// </summary>
        /// <param name="data">The data.</param>
        public DataReceivedEventArgs(byte[] data)
        {
            Data = data;
        }
        /// <summary>
        /// The data.
        /// </summary>
        public byte[] Data;
    }
}
