using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
	/// ZW040x Programming State byte enumeration.
    /// </summary>
	public enum ZW040xProgrammingState
    {
        /// <summary>
        /// This bit will go high when a Run CRC Check
		/// command has been sent to the Single Chip. It will
		/// return to low when the CRC check procedure is done.
        /// </summary>
        CrcBusy = 0x01,
        /// <summary>
        /// This bit is cleared when a Run CRC Check
		/// command is issued and it will be set if the CRC check
		/// procedure passes.
        /// </summary>  
        CrcDone = 0x02,
		/// <summary>
		/// This bit is cleared when a Run CRC Check
		/// command is issued and it will be set if the CRC check
		/// procedure fails.
		/// </summary>
		CrcFailed = 0x04,
		/// <summary>
        /// This bit is high if the OTP programming logic is busy
		/// programming the OTP.
        /// </summary>
        WriteOperationBusy = 0x08,
        /// <summary>
        /// This bit is cleared when a Write OTP command is
		/// issued and it will be set if the OTP write operation
		/// fails.
        /// </summary>
        WriteOperationFailed = 0x10,
        /// <summary>
        /// This bit will be set if either a Continue Write
		/// Operation or a Continue Read Operation are
		/// refused. These operations will be refused if:
		/// A Continue Write Operation is not succeeding a
		/// Write SRAM or a Continue Write Operation
		/// command
		/// A Continue Read Operation is not succeeding a
		/// Read OTP, a Read SRAM or a Continue Read
		/// Operation command
        /// </summary>
        ContOperationRefused = 0x20,
        /// <summary>
        /// This bit is set if the Development Mode has been enabled
        /// </summary>
        DevelopmentModeEnabled = 0x40,
        /// <summary>
        /// This bit is set if the Execute out of SRAM Mode has been enabled
        /// </summary>
        ExecSramModeEnabled = 0x80,
    }
}
