using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Statuses of ZW_RequestNetWorkUpdate command.
    /// #define ZW_SUC_UPDATE_DONE      0x00
    /// #define ZW_SUC_UPDATE_ABORT     0x01
    /// #define ZW_SUC_UPDATE_WAIT      0x02
    /// #define ZW_SUC_UPDATE_DISABLED  0x03
    /// #define ZW_SUC_UPDATE_OVERFLOW  0x04
    /// </summary>
    public enum RequestNetworkUpdateStatuses
    {
        /// <summary>
        /// The update process succeeded.
        /// </summary>
        SucUpdateDone = 0x00,
        /// <summary>
        /// The update process aborted because of an error.
        /// </summary>
        SucUpdateAbort = 0x01,
        /// <summary>
        /// The SUC node is busy.
        /// </summary>
        SucUpdateWait = 0x02,
        /// <summary>
        /// The SUC functionality is disabled.
        /// </summary>
        SucUpdateDisabled = 0x03,
        /// <summary>
        /// The controller requested an update after more than 64 changes have occurred in the network. The update information is
        /// then out of date in respect to that controller. In this situation the controllerhave to make a replication before trying
        /// to request any new network updates.
        /// </summary>
        SucUpdateOverflow = 0x04
    }
}
