using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Libraries enumeration.
    /// </summary>
    public enum Libraries
    {
        /// <summary>
        /// No Library was found. 
        /// </summary>
        NoLib = 0x00,
        /// <summary>
        /// A Static Controller library was found.
        /// </summary>
        ControllerStaticLib = 0x01,
        /// <summary>
        /// A Controller library was found.
        /// </summary>
        ControllerPortableLib = 0x02,
        /// <summary>
        /// A Enhanced Slave ibrary was found.
        /// </summary>
        SlaveEnhancedLib = 0x03,
        /// <summary>
        /// A Slave library was found.
        /// </summary>
        SlaveLib = 0x04,
        /// <summary>
        /// An Installer Controller library was found. 
        /// </summary>
        InstallerLib = 0x05,
        /// <summary>
        /// A Routing Slave library was found.
        /// </summary>
        SlaveRoutingLib = 0x06,
        /// <summary>
        /// A Bridge Controller library was found.
        /// </summary>
        ControllerBridgeLib = 0x07
    }
}
