using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Devices
{
    /// <summary>
    /// This interface provides methods that allow the client program using Installer Controller specific Serial API.
    /// </summary>
    public interface IInstallerController : IController
    {
        /// <summary>
        /// Gets the transmit count.
        /// </summary>
        void TransmitCount();
        /// <summary>
        /// Stores the node info.
        /// </summary>
        bool StoreNodeInfo(byte nodeId, byte capability, byte security, byte reserved, byte basic, byte generic, byte specific);
        /// <summary>
        /// Stores the home ID.
        /// </summary>
        void StoreHomeID(byte[] homeId, byte nodeId);
    }
}
