using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Threading;

namespace Zensys.ZWave.SerialPortTransport
{
    class SocketAsyncClient
    {
        public event Action<byte[]> DataReceived;
        Thread receiverThread;
        TcpClient tcpClient;
        NetworkStream clientStream;

        public SocketAsyncClient()
        {

        }

        public void Send(byte[] data)
        {
            clientStream.Write(data, 0, data.Length);
            clientStream.Flush();
        }

        public bool IsOpen;

        public bool Connected
        {
            get
            {
                if (tcpClient != null)
                    return tcpClient.Connected;
                else
                    return false;
            }
        }

        private string mConnectionString;
        public string ConnectionString
        {
            get { return mConnectionString; }
        }

        public void Connect(string connectionString)
        {
            if (!String.IsNullOrEmpty(connectionString) && connectionString.Contains(":"))
            {
                string[] connectionStrings = connectionString.Split(':');
                if (connectionStrings.Length == 2)
                {
                    mConnectionString = connectionString;
                    IPAddress ip = IPAddress.Parse(connectionStrings[0]);
                    if (ip != null)
                    {
                        int iPortNo = Convert.ToInt16(connectionStrings[1]);
                        IPEndPoint ipEnd = new IPEndPoint(ip, iPortNo);
                        Open(ipEnd);
                    }
                }
            }
        }

        public void Open(IPEndPoint serverEndPoint)
        {
            isClosing = false;
            signal.Reset();
            tcpClient = new TcpClient();
            tcpClient.NoDelay = true;
            tcpClient.Client.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.KeepAlive, true);
            tcpClient.Connect(serverEndPoint);
            clientStream = tcpClient.GetStream();

            receiverThread = new Thread(new ThreadStart(HandleClientComm));
            receiverThread.Start();
            receiverThread.IsBackground = true;
            IsOpen = true;
        }

        public void Close()
        {
            if (IsOpen)
            {
                isClosing = true;
                signal.Set();
                clientStream.Close();
                receiverThread.Join();
                tcpClient.Close();
                IsOpen = false;
            }
        }

        volatile bool isClosing = false;

        private void ReadCompleted(IAsyncResult result)
        {
            if (!isClosing)
            {
                try
                {
                    NetworkStream ns = (NetworkStream)result.AsyncState;
                    bytesRead = ns.EndRead(result);
                }
                catch (Exception ex)
                {
                    Console.Out.WriteLine(ex.Message);
                }
            }
            signal.Set();
        }

        private AutoResetEvent signal = new AutoResetEvent(false);
        volatile int bytesRead = 0;
        private void HandleClientComm()
        {
            byte[] message = new byte[4096];
            while (!isClosing)
            {
                bytesRead = 0;
                try
                {
                    //blocks until a client sends a message
                    IAsyncResult result = clientStream.BeginRead(message, 0, 4096, ReadCompleted, clientStream);
                    signal.WaitOne();
                    //bytesRead = clientStream.Read(message, 0, 4096);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    //a socket error has occured
                    break;
                }
                if (!isClosing)
                {
                    if (bytesRead == 0)
                    {
                        //the client has disconnected from the server
                        break;
                    }

                    if (DataReceived != null)
                    {
                        byte[] data = new byte[bytesRead];
                        Array.Copy(message, data, bytesRead);
                        DataReceived(data);
                    }
                }
            }
        }
    }
}
