using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Logging;

namespace Zensys.ZWave.SerialPortApplication.Devices
{
    public class InstallerController : Controller, IInstallerController
    {
        internal InstallerController(ISessionLayer sessionLayer, bool useExternalCommandClassesStorage )
            : base(sessionLayer, useExternalCommandClassesStorage)
        {
            
        }
        #region IInstallerController Members

        public void TransmitCount()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public bool StoreNodeInfo(byte nodeId, byte capability, byte security, byte reserved, byte basic, byte generic, byte specific)
        {
            LogTopSession();
            bool result = false;
            if (IsSupportedSerialApiCommand((byte)CommandTypes.CmdStoreNodeInfo, true))
            {
                List<byte[]> responses = SessionLayer.ExecuteRequest(
                    (byte)CommandTypes.CmdStoreNodeInfo, 
                    2,
                    (int)SessionLayer.RequestTimeout.TotalMilliseconds,
                    new byte[] { nodeId, capability, security, reserved, basic, generic, specific, SessionLayer.SequenceNumber });
                if (responses.Count == 2 && responses[0] != null && responses[0].Length > 0)
                {
                    result = Convert.ToBoolean(responses[0][0]);
                }
            }
            return result;
        }

        public void StoreHomeID(byte[] homeId, byte nodeId)
        {
            LogTopSession();
            if (IsSupportedSerialApiCommand((byte)CommandTypes.CmdStoreHomeId, true))
            {
                SessionLayer.ExecuteRequest((byte)CommandTypes.CmdStoreHomeId, new byte[] { homeId[0], homeId[1], homeId[2], homeId[3], nodeId, SessionLayer.SequenceNumber });
            }
        }

        #endregion

    }
}
