using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;

namespace Zensys.ZWave.SerialPortApplication.Devices
{
    public class DeviceInfo : IDeviceInfo
    {
        private byte mId;
        public byte Id
        {
            get { return mId; }
            set { mId = value; }
        }

        private string mType;
        public string Type
        {
            get { return mType; }
            set { mType = value; }
        }
	
        private byte[] mHomeId;
        public byte[] HomeId
        {
            get { return mHomeId; }
            set { mHomeId = value; }
        }
        private byte mCapability;
        public byte Capability
        {
            get { return mCapability; }
            set { mCapability = value; }
        }

        private byte mSecurity;
        public byte Security
        {
            get { return mSecurity; }
            set { mSecurity = value; }
        }

        private byte mReserved;
        public byte Reserved
        {
            get { return mReserved; }
            set { mReserved = value; }
        }

        private byte mBasic;
        public byte Basic
        {
            get { return mBasic; }
            set { mBasic = value; }
        }

        private byte mGeneric;
        public byte Generic
        {
            get { return mGeneric; }
            set { mGeneric = value; }
        }

        private byte mSpecific;
        public byte Specific
        {
            get { return mSpecific; }
            set { mSpecific = value; }
        }

        private bool mIsSlaveApi;
        public bool IsSlaveApi
        {
            get { return mIsSlaveApi; }
            set { mIsSlaveApi = value; }
        }

        private bool mIsVirtual;
        public bool IsVirtual
        {
            get { return mIsVirtual; }
            set { mIsVirtual = value; }
        }

        private byte[] mSupportedCommandClasses;
        public byte[] SupportedCommandClasses
        {
            get { return mSupportedCommandClasses; }
            set { mSupportedCommandClasses = value; }
        }

        public bool IsListening
        {
            get
            {
                return (this.Capability & 0x80) != 0;
            }
        }


        private string ToHexString(byte val)
        {
            string strData = "";
            if (val < 0x10)
                strData += 0;
            strData += val.ToString("X");
            return strData;
        }

        public bool IsCommandQueueOverrided
        {
            get
            {
                if (mCommandQueueOverrided == null)
                {
                    return false;
                }
                else
                {
                    return (bool)mCommandQueueOverrided;
                }
            }
        }
        private bool? mCommandQueueOverrided;
        public bool? CommandQueueOverrided
        {
            get { return mCommandQueueOverrided; }
            set { mCommandQueueOverrided = value; }
        }
    }
}
