﻿using System;
using System.Collections.Generic;

using System.Text;

using System.Xml.Serialization;
using Zensys.Framework;

namespace Zensys.ZWave.Application
{
    public partial class SpecificDevice
    {
        [XmlIgnore]
        public byte KeyId
        {
            get
            {
                return Tools.GetByte(Key);
            }
            set
            {
                Key = Tools.GetHex(value, true);
            }
        }

        [XmlIgnore]
        public byte ScopeKeyId
        {
            get
            {
                return Tools.GetByte(ScopeKey);
            }
            set
            {
                ScopeKey = Tools.GetHex(value, true);
            }
        }

        private GenericDevice parentField;
        [XmlIgnore]
        public GenericDevice Parent
        {
            get
            {
                return this.parentField;
            }
            set
            {
                this.parentField = value;
                this.RaisePropertyChanged("Parent");
            }
        }
    }
}
