﻿using System;
using System.Collections.Generic;

using System.Text;

namespace Zensys.ZWave.Application
{
    public class ParamValue
    {
        private Param mParamDefinition;

        public Param ParamDefinition
        {
            get { return mParamDefinition; }
            set { mParamDefinition = value; }
        }
        private string mTextValue;
        public string TextValue
        {
            get
            {
                if (mTextValue == null)
                {
                    if (TextValueList != null)
                    {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < TextValueList.Count; i++)
                        {
                            if (i < TextValueList.Count - 1)
                            {
                                sb.AppendLine(TextValueList[i]);
                            }
                            else
                            {
                                sb.Append(TextValueList[i]);
                            }
                        }
                        mTextValue = sb.ToString();
                    }
                }
                return mTextValue;
            }

        }
        private List<string> mTextValueList;

        public List<string> TextValueList
        {
            get { return mTextValueList; }
            set { mTextValueList = value; }
        }
        private List<byte> mByteValueList;

        public List<byte> ByteValueList
        {
            get { return mByteValueList; }
            set { mByteValueList = value; }
        }

        private List<ParamValue> mParamValues;
        public List<ParamValue> ParamValues
        {
            get { return mParamValues; }
            set { mParamValues = value; }
        }

        private object mFormatter;
        public object Formatter
        {
            get { return mFormatter; }
            set { mFormatter = value; }
        }
        public ParamValue()
        {
            TextValueList = new List<string>();
            ByteValueList = new List<byte>();
        }
        public static ParamValue CreateParamValue(Param item)
        {
            ParamValue ret = new ParamValue();
            ret.ByteValueList = new List<byte>();
            ret.ByteValueList.Add(0);
            ret.TextValueList = new List<string>();
            ret.ParamDefinition = item;
            if (item.Param1 != null && item.Param1.Count > 0)
            {
                ret.ParamValues = new List<ParamValue>();
                ParamValue pv = new ParamValue();
                pv.ByteValueList = new List<byte>();
                pv.ByteValueList.Add(0);
                pv.TextValueList = new List<string>();
                pv.ParamDefinition = item;
                pv.ParamValues = new List<ParamValue>();
                foreach (Param p in item.Param1)
                {
                    pv.ParamValues.Add(ParamValue.CreateParamValue(p));
                }
                ret.ParamValues.Add(pv);
            }
            return ret;
        }

        public override string ToString()
        {
            return this.ParamDefinition.Text;
        }
    }
}
