/*********************************  Timer.c  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: See below.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-08-31   OZA     Integrated with Z-Wave environment.
 *
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.1 $
 * Last Changed:     $Date: 2007/08/31 11:39:20 $
 * Ported to iccAVR
 ****************************************************************************/

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include  "TYPES.H"			// Standard types

#ifdef __GNUC__
#include <avr/io.h>
#include <avr/interrupt.h>
#else
#include  <iom128.h>
#endif

//#include "ZW_basis.h"
#include "Timer.h"

BYTE timerTr;

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
/* From ZW_itmer.h header file */
extern  volatile BYTE timerCount; /* Incremented every 10 msec. by an interrupt function, */

/****************************************************************************/
/*                              Interrupt                                   */
/****************************************************************************/
#ifdef __GNUC__
ISR(TIMER0_COMP_vect)
#else
#pragma vector=TIMER0_COMP_vect
__interrupt void irqTimerInterrupt(void)
#endif
{
   timerCount++;
   if(timerTr) timerTr--;
}

/*********************************************************************
 * Function:        void TimerInit(void)
 *
 * PreCondition:    none
 *
 * Input:       	none
 *
 * Output:      	none
 *
 * Side Effects:    None
 *
 * Overview:        Initializes Timer0 for use.
 *
 * Note:            None
 ********************************************************************/
void TimerInit(void)
{
//    ACSR=0x80;
//    SFIOR=0x00;

    ASSR=0x00;
    TCCR0=0x0F; // | 1<<COM00;
    TCNT0=0x00;
    OCR0=0x47; //0x23;

    TIMSK |= 1 << OCIE0;
}

BYTE getTimerTr()
{
  return timerTr;
}

void setTimerTr()
{
  timerTr = 30;
}

void clrTimerTr()
{
  timerTr = 0;
}


